/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Connection component state transition actions 
 */


#ifndef LLC_C_AC_H
#define LLC_C_AC_H

/* 
 * Connection state transition actions
 * (Fb = F bit; Pb = P bit; Xb = X bit)
 */
#define CONN_AC_CLEAR_REMOTE_BUSY                          1
#define CONN_AC_CONNECT_INDICATION                         2
#define CONN_AC_CONNECT_CONFIRM                            3
#define CONN_AC_DATA_INDICATION                            4
#define CONN_AC_DISCONNECT_INDICATION                      5
#define CONN_AC_RESET_INDICATION                           6
#define CONN_AC_RESET_CONFIRM                              7
#define CONN_AC_REPORT_STATUS                              8
#define CONN_AC_CLEAR_REMOTE_BUSY_IF_Fb_EQ_1               9
#define CONN_AC_STOP_REJ_TIMER_IF_DATA_FLAG_EQ_2           10
#define CONN_AC_SEND_DISC_CMD_Pb_SET_X                     11
#define CONN_AC_SEND_DM_RSP_Fb_SET_Pb                      12
#define CONN_AC_SEND_DM_RSP_Fb_SET_1                       13
#define CONN_AC_SEND_DM_RSP_Fb_SET_F_FLAG                  14
#define CONN_AC_SEND_FRMR_RSP_Fb_SET_X                     15
#define CONN_AC_RESEND_FRMR_RSP_Fb_SET_0                   16
#define CONN_AC_RESEND_FRMR_RSP_Fb_SET_Pb                  17
#define CONN_AC_SEND_I_CMD_Pb_SET_1                        18
#define CONN_AC_RESEND_I_CMD_Pb_SET_1                      19
#define CONN_AC_RESEND_I_CMD_Pb_SET_1_OR_SEND_RR           20
#define CONN_AC_SEND_I_XXX_Xb_SET_0                        21
#define CONN_AC_RESEND_I_XXX_Xb_SET_0                      22
#define CONN_AC_RESEND_I_XXX_Xb_SET_0_OR_SEND_RR           23
#define CONN_AC_RESEND_I_RSP_Fb_SET_1                      24
#define CONN_AC_SEND_REJ_CMD_Pb_SET_1                      25
#define CONN_AC_SEND_REJ_RSP_Fb_SET_1                      26
#define CONN_AC_SEND_REJ_XXX_Xb_SET_0                      27
#define CONN_AC_SEND_RNR_CMD_Pb_SET_1                      28
#define CONN_AC_SEND_RNR_RSP_Fb_SET_1                      29
#define CONN_AC_SEND_RNR_XXX_Xb_SET_0                      30
#define CONN_AC_SET_REMOTE_BUSY                            31
#define CONN_AC_OPTIONAL_SEND_RNR_XXX_Xb_SET_0             32
#define CONN_AC_SEND_RR_CMD_Pb_SET_1                       33
#define CONN_AC_SEND_ACK_CMD_Pb_SET_1                      34
#define CONN_AC_SEND_RR_RSP_Fb_SET_1                       35
#define CONN_AC_SEND_ACK_RSP_Fb_SET_1                      36
#define CONN_AC_SEND_RR_XXX_Xb_SET_0                       37
#define CONN_AC_SEND_ACK_XXX_Xb_SET_0                      38
#define CONN_AC_SEND_SABME_CMD_Pb_SET_X                    39
#define CONN_AC_SEND_UA_RSP_Fb_SET_Pb                      40
#define CONN_AC_SEND_UA_RSP_Fb_SET_F_FLAG                  41
#define CONN_AC_S_FLAG_SET_0                               42
#define CONN_AC_S_FLAG_SET_1                               43
#define CONN_AC_START_P_TIMER                              44
#define CONN_AC_START_ACK_TIMER                            45
#define CONN_AC_START_REJ_TIMER                            46
#define CONN_AC_START_ACK_TIMER_IF_NOT_RUNNING             47
#define CONN_AC_STOP_ACK_TIMER                             48
#define CONN_AC_STOP_P_TIMER                               49
#define CONN_AC_STOP_REJ_TIMER                             50
#define CONN_AC_STOP_ALL_TIMERS                            51
#define CONN_AC_STOP_OTHER_TIMERS                          52
#define CONN_AC_UPDATE_Nr_RECEIVED                         53
#define CONN_AC_UPDATE_P_FLAG                              54
#define CONN_AC_DATA_FLAG_SET_2                            55
#define CONN_AC_DATA_FLAG_SET_0                            56
#define CONN_AC_DATA_FLAG_SET_1                            57
#define CONN_AC_DATA_FLAG_SET_1_IF_DATA_FLAG_EQ_0          58
#define CONN_AC_P_FLAG_SET_0                               59
#define CONN_AC_P_FLAG_SET_P                               60
#define CONN_AC_REMOTE_BUSY_SET_0                          61
#define CONN_AC_RETRY_COUNT_SET_0                          62
#define CONN_AC_RETRY_COUNT_INCREMENT_BY_1                 63
#define CONN_AC_Vr_SET_0                                   64
#define CONN_AC_Vr_INCREMENT_BY_1                          65
#define CONN_AC_Vs_SET_0                                   66
#define CONN_AC_Vs_SET_Nr                                  67
#define CONN_AC_F_FLAG_SET_P                               68
#define CONN_AC_STOP_SENDACK_TIMER                         70
#define CONN_AC_START_SENDACK_TIMER_IF_NOT_RUNNING         71

typedef us16 (*conn_action_t)(connection_t * conn,
                                    conn_state_event_t * event);


#ifdef LLC_C_AC_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_C_AC_C */


EXTRN us16     conn_ac_clear_remote_busy (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_connect_indication (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_connect_confirm (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_data_indication (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_disconnect_indication (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_reset_indication (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_reset_confirm (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_report_status (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_clear_remote_busy_if_f_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_stop_rej_timer_if_data_flag_eq_2 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_disc_cmd_p_set_x (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_dm_rsp_f_set_p (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_dm_rsp_f_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_dm_rsp_f_set_f_flag (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_frmr_rsp_f_set_x (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_frmr_rsp_f_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_frmr_rsp_f_set_p (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_i_cmd_p_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_i_cmd_p_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_i_cmd_p_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_i_cmd_p_set_1_or_send_rr (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_i_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_i_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_i_xxx_x_set_0_or_send_rr (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_resend_i_rsp_f_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rej_cmd_p_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rej_rsp_f_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rej_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rnr_cmd_p_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rnr_rsp_f_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rnr_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_remote_busy (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_optional_send_rnr_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rr_cmd_p_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_ack_cmd_p_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rr_rsp_f_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_ack_rsp_f_set_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_rr_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_ack_xxx_x_set_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_sabme_cmd_p_set_x (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_ua_rsp_f_set_f_flag (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_send_ua_rsp_f_set_p (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_s_flag_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_s_flag_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_start_p_timer (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_start_ack_timer (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_start_rej_timer (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_start_ack_timer_if_not_running (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_stop_ack_timer (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_stop_p_timer (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_stop_rej_timer (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_stop_all_timers (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_stop_other_timers (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_update_nr_received (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_increase_transmit_window_size (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_decrease_transmit_window_size (connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_update_p_flag (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_data_flag_2 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_data_flag_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_data_flag_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_data_flag_1_if_data_flag_eq_0 (
                           connection_t * conn, conn_state_event_t * event);
EXTRN us16     conn_ac_set_p_flag_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_p_flag_1(connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_set_p_flag_p (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_remote_busy_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_retry_count_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_cause_flag_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_cause_flag_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_increment_retry_count_by_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_vr_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_increment_vr_by_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_vs_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_vs_nr (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_reset_vs (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_update_vs (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_set_f_flag_p (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_disconnect (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_reset(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_disconnect_confirm (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us8     circular_between(us8 a, us8 b, us8 c);

EXTRN us16     conn_ac_send_ack_if_needed (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ac_increase_npta_value (connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_adjust_npta_by_rr (connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_adjust_npta_by_rnr (connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_reset_sendack_flag (connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_send_rr_rsp_f_set_ackpf(connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_send_i_rsp_f_set_ackpf(connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_send_i_rsp_as_ack(connection_t * conn,
                                                conn_state_event_t * event);

EXTRN us16     conn_ac_send_i_as_ack(connection_t * conn,
                                                conn_state_event_t * event);


#undef EXTRN
#endif /* LLC_C_AC_H */

