/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines global values for LLC layer and method for accessing values 
 */


#ifndef LLC_GLOB_H
#define LLC_GLOB_H


#include <linux/netdevice.h>
#include <linux/sched.h>


/* Actions which can be performed against global parameters */
#define ACTION_GET         1
#define ACTION_SET         2
#define SECS_TO_CT(x)      ((x) * HZ) 
#define CT_TO_SECS(x)      ((x) / HZ) 


#define EVENT              1
#define FRAME              2

#define TYPE_1             1
#define TYPE_2             2

#define DEST_INVALID   0           /* Invalid LLC PDU type */
#define DEST_SAP       1           /* Type 1 goes here */
#define DEST_CONN      2           /* Type 2 goes here */

#define P_TIME       2 
#define ACK_TIME     3 
#define REJ_TIME     3
#define BUSY_TIME    3 
#define SENDACK_TIME 50

#ifndef LLC_GLOB_C
#define EXTRN extern
#else
#define EXTRN
#endif /* LLC_GLOB_C */

extern prim_if_block_t     Ind_prim,Cfm_prim;
extern prim_data_u         Ind_data_prim,Cfm_data_prim;
 
EXTRN us16         llc_glob_init (void);
EXTRN us16         llc_glob_exit (void);
                   
EXTRN us16         access_max_nbr_saps (us8 action, us32 * access_value);
EXTRN us16         access_max_nbr_connections (us8 action,
                                                       us32 * access_value);
EXTRN us16         access_max_pdu_octets (us8 action, us32 * access_value);
EXTRN us16         access_min_pdu_octets (us8 action, us32 * access_value);
EXTRN us16         access_device_mac_addr (us8 action, struct device * dev,
                                                           us8 * mac_addr);
EXTRN us16         access_all_devices (us8 action, void ** dev, 
                                                          us32 * nbr_devs);


#undef EXTRN
#endif /* LLC_GLOB_H */


