/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
#ifndef USR_TO_KRNL_H
#define USR_TO_KRNL_H



#define  CONNECT_PRIM               1
#define  I_PRIM                     2
#define  DISCONNECT_PRIM            3
#define  RESET_PRIM                 4

#define  LBUSY_DET                  5
#define  LBUSY_CLR                  6

#define  SEND_I_C                   7
#define  SEND_I_R                   8
#define  SEND_SABME_C               9
#define  SEND_UA_R                  10
#define  SEND_DISC_C                11
#define  SEND_DM_R                  12
#define  SEND_REJ_C                 13
#define  SEND_REJ_R                 14
#define  SEND_RR_C                  15
#define  SEND_RR_R                  16
#define  SEND_RNR_C                 17
#define  SEND_RNR_R                 18
#define  SEND_FRMR_R                19


typedef struct
{
   unsigned char p_flag, f_flag, s_flag, rmt_busy_flag;
   unsigned char retry_count;
   unsigned long n1, n2;

   unsigned char vr, vs;
   int set_vr, set_vs;

} ConnecInfo;


#define DEST_MACH_NAME_LEN 39

typedef struct
{
   int pf_bit;
   char dest_machine[DEST_MACH_NAME_LEN+1];
   ConnecInfo c_info;
} LLC_Data;


#define LLC_CALL(fd, func_id, llcd)\
   (ioctl((fd), (func_id), (llcd)) < 0? (printf("\nError in IOCTL"), 1): 0)

#endif
