/*
 *  vtuneshared.h
 *
 *  Copyright (C) 2002 Intel Corporation
 *  Author/Maintainer - George W Artz <george.w.artz@intel.com>
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
#include "driversharedarea.h"

/*
******************************************************************************
*           Linux driver shared defs
******************************************************************************
*/

#define DEV_SAMPLING_DRIVER     "/dev/vtune_d"  // device 0
#define DEV_MODULES             "/dev/vtune_m"  // device 1
#define DEV_PID_CREATES         "/dev/vtune_p"  // device 2

#define VLIB_MAPFUNC            50

 /* GFP_KERNEL declaration */
//#define GFP_KERNEL  (0x02 |0x01| 0x04)
/* KERN_INFO declaration */
#define KERN_INFO "<6>"

/* Error Codes: general */
#define LIB_RET_SUCCESS            0
#define LIBERR_DEVICE_FAIL         100
#define LIBERR_IOCTL_FAIL          102
#define LIBERR_DEVICE_CONFIG       104
#define LIBERR_CPUINFO_FAIL        106
#define LIBERR_SYSINFO_FAIL        108
#define LIB_SAMP_CANCEL            110
/* Error Codes: sampling record related */
#define LIBERR_VTEMP_CREATE        200
#define LIBERR_SAMPF_CREATE        202
#define LIBERR_PCWRITE             204
#define LIBERR_FTEMPSEEK           206
#define LIBERR_SAMPSEEK            208
#define LIBERR_SAMPREAD            210
#define LIBERR_SAMPWRITE           212
#define LIBERR_USERSAMPALLOC_FAIL  214
/* Error Codes: module record related */
#define LIBERR_DIRPROC_FAIL        300
#define LIBERR_MODF_CREATE         302
#define LIBERR_MODDEV_FAIL         304
#define LIBERR_MODQUERY            306
#define LIBERR_MODOPEN             308
#define LIBERR_MODINFO             310
#define LIBERR_MODWRITE            312
#define LIBERR_USERMODALLOC_FAIL   314
/* Error Codes: pid record related */
#define LIBERR_PIDDEV_OPEN_FAIL    400
#define LIBERR_PIDFILE_CREATE_FAIL 402
#define LIBERR_PIDFILE_OPEN_FAIL   404
#define LIBERR_PIDREC_WRITE_FAIL   406

/* Sampling Driver State */
#define SINFO_STARTED             0x08  // sampling started
#define SINFO_WRITE               0x04  // write procedure scheduled
#define SINFO_STOPPING            0x02  // driver is stopping sampling
#define SINFO_STOP_COMPLETE       0x01  // driver completed "stop sampling" cmd
#define SINFO_EBS_RESTART         0x20  // restart EBS
#define SINFO_DO_STOP             0x40  // schedule stop
#define SINFO_DO_WRITE            0x80  // schedule write

/* NMI type */
#define EISA_NMI               1
#define QUIX_NMI               2
#define STAT_NMI               3
#define EMON_NMI               4

/* Driver IOCTL Defs */
#define VTUNE_CONFIG           1  // return # of processors
#define VTUNE_START            2  // return 0 or 1, is prf enabled?
#define VTUNE_STOP             3  // return number of text symbols loaded
#define VTUNE_STAT             4  // return size of symbol names
#define VTUNE_ABORT            5  // users abort collection data
#define VTUNE_PARM             6  // return user configure vtune parm
#define VTUNE_DUMP             7  // dump system debug info
#define VTUNE_SYSINFO          9  // return os system info
#define VTUNE_CONFIG_EX       12  // new model config
#define VTUNE_START_EX        15  // new model start
#define VTUNE_READPERF        18  // read perf data
#define VTUNE_GETCPUINFO      19  // get cpu info

#define PS_VM         0x00020000  // virtual 86 mode flag

#define MAXPATHLEN        1024
#define MAXNAMELEN         256
#define MAX_PROCS           32

/*
 *  Sample information structure... maintained by Linux driver
 */
typedef struct _Samp_info {
  int sample_time;        // total sample time in milleseconds
  int profile_ints_idt;   // total physical profile interrupts during  sampling
  int profile_ints;       // total profile interrupts while sampling  (callback from OS)
  int sample_count;       // total samples taken. Current sample number.
  int test_IO_errs;       // number of times that VxD IO request was delayed (Win95)
  int sampling_active;    // pc sampling active (0 = pc sampling suspended)
  int flags;              // flags
  int sample_rec_length;  // lentgh of sample record
  int rsvd2;              // reserved 2
  char cpu_family;        // cpu family
  char cpu_model;           // cpu model
  char cpu_stepping;      // cpu stepping
  char rsvd3;             // reserved 3
} sampinfo_t;

/* Sampling system info */
typedef struct _sys_samp_info {
  int cpu_I_dmap[MAX_PROCS];  // CPU ID info for all  processors
  int cpu_feature_bits;       // feature bits, global for all now
  int num_processors;         // Total CPUs detected
  int cpu_speed;              // CPU Speed
  int lib_version_major;      // VTune perf Lib Version Major
  int lib_version_minor;      // VTune perf Lib Version Minor
  int sysdrv_version_major;   // VTune Driver Version Major
  int sysdrv_version_minor;   // VTune Driver Version Minor
  int feature_set;            // features supported by CPU and OS
  int reservedB;              // Reserved Field B (TBD)
  int reservedC;              // Reserved Field C (TBD)
  int reservedD;              // Reserved Field D (TBD)
  int reservedE;              // Reserved Field E (TBD)
} sys_samp_info;

#define FSET_DRV_PROCESS_CREATES_TRACKED_IN_MODULE_RECS 0x1

typedef enum boolean { B_FALSE, B_TRUE } boolean_t;

typedef boolean_t BOOLEAN;
