/*
 * linux/drivers/ide/cenatek.c		Version 0.01
 *
 * Copyright (C) 2002-2002		Andre Hedrick <andre@linux-ide.org>
 *					Arjan van de Ven <arjanv@redhat.com>
 * May be copied or modified under the terms of the GNU General Public License
 *
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include <linux/ioport.h>
#include <linux/blkdev.h>
#include <linux/hdreg.h>

#include <linux/interrupt.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/ide.h>

#include <asm/io.h>
#include <asm/irq.h>

#include "ide_modes.h"
#include "cenatek.h"

/*
 * Here is where all the hard work goes to program the chipset.
 */
static int cenatek_tune_chipset (ide_drive_t *drive, u8 xferspeed)
{
	return 0;
}

static void cenatek_tune_drive (ide_drive_t *drive, u8 pio)
{
	return;
}

static unsigned int __init init_chipset_cenatek (struct pci_dev *dev, const char *name)
{
	return 0;
}

static void __init init_hwif_cenatek (ide_hwif_t *hwif)
{
	hwif->tuneproc = &cenatek_tune_drive;
	hwif->speedproc = &cenatek_tune_chipset;
	hwif->autodma = 1;
	hwif->drives[0].autodma = hwif->autodma;
	hwif->drives[1].autodma = hwif->autodma;
}

/* FIXME - not needed */
static void __init init_dma_cenatek (ide_hwif_t *hwif, unsigned long dmabase)
{
	ide_setup_dma(hwif, dmabase, 8);
}

extern void ide_setup_pci_device(struct pci_dev *, ide_pci_device_t *);

static int __devinit cenatek_init_one(struct pci_dev *dev, const struct pci_device_id *id)
{
	ide_pci_device_t *d = &cenatek_chipsets[id->driver_data];
	if (dev->device != d->device)
		BUG();
	ide_setup_pci_device(dev, d);
	MOD_INC_USE_COUNT;
	return 0;
}

static struct pci_device_id cenatek_pci_tbl[] __devinitdata = {
	{ PCI_VENDOR_ID_CENATEK, PCI_DEVICE_ID_CENATEK_IDE, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{ 0, },
};

static struct pci_driver driver = {
	.name		= "Cenatek IDE",
	.id_table	= cenatek_pci_tbl,
	.probe		= cenatek_init_one,
};

static int cenatek_ide_init(void)
{
	return ide_pci_register_driver(&driver);
}

static void cenatek_ide_exit(void)
{
	ide_pci_unregister_driver(&driver);
}

module_init(cenatek_ide_init);
module_exit(cenatek_ide_exit);

MODULE_AUTHOR("Arjan van de Ven");
MODULE_DESCRIPTION("PCI driver module for cenatek IDE");
MODULE_LICENSE("GPL");

EXPORT_NO_SYMBOLS;
