/*
 * file taken from openbsd's compat/linux/linux_sysent.c
 */

/*	$OpenBSD: linux_sysent.c,v 1.36 2002/06/05 19:43:44 jasoni Exp $	*/


#include <linux/sched.h>
#include <linux/smp_lock.h>
#include <linux/mm.h>
#include <linux/pagemap.h>
#include <linux/fs.h>
#include <linux/wait.h>
#include <linux/queue.h>

#include <asm/uaccess.h>
#include <asm/ptrace.h>
#include <asm/semaphore.h>

#include <linux/systrace.h>

/* #define	s(type)	sizeof(type) */
#define	s(type)	0

struct sysent linux_sysent[] = {
	{ 0, 0 },			/* 0 = syscall */
	{ 1, s(struct sys_exit_args) },				/* 1 = exit */
	{ 0, 0 },				/* 2 = fork */
	{ 3, s(struct sys_read_args) },				/* 3 = read */
	{ 3, s(struct sys_write_args) },			/* 4 = write */
	{ 3, s(struct linux_sys_open_args) },			/* 5 = open */
	{ 1, s(struct sys_close_args) },			/* 6 = close */
	{ 3, s(struct linux_sys_waitpid_args) },		/* 7 = waitpid */
	{ 2, s(struct linux_sys_creat_args) },			/* 8 = creat */
	{ 2, s(struct sys_link_args) },				/* 9 = link */
	{ 1, s(struct linux_sys_unlink_args) },			/* 10 = unlink */
	{ 3, s(struct linux_sys_execve_args) },			/* 11 = execve */
	{ 1, s(struct linux_sys_chdir_args) },			/* 12 = chdir */
	{ 1, s(struct linux_sys_time_args) },			/* 13 = time */
	{ 3, s(struct linux_sys_mknod_args) },			/* 14 = mknod */
	{ 2, s(struct linux_sys_chmod_args) },			/* 15 = chmod */
	{ 3, s(struct linux_sys_lchown16_args) },		/* 16 = lchown16 */
	{ 1, s(struct linux_sys_break_args) },			/* 17 = break */
	{ 0, 0 },			/* 18 = ostat */
	{ 3, s(struct compat_43_sys_lseek_args) },		/* 19 = lseek */
	{ 0, 0 },			/* 20 = getpid */
	{ 5, s(struct linux_sys_mount_args) },			/* 21 = mount */
	{ 1, s(struct linux_sys_umount_args) },			/* 22 = umount */
	{ 1, s(struct sys_setuid_args) },			/* 23 = linux_setuid16 */
	{ 0, 0 },			/* 24 = linux_getuid16 */
	{ 1, s(struct linux_sys_stime_args) },			/* 25 = stime */
	{ 0, 0 },			/* 26 = unimplemented ptrace */
	{ 1, s(struct linux_sys_alarm_args) },			/* 27 = alarm */
	{ 0, 0 },			/* 28 = ofstat */
	{ 0, 0 },			/* 29 = pause */
	{ 2, s(struct linux_sys_utime_args) },			/* 30 = utime */
	{ 0, 0 },			/* 31 = stty */
	{ 0, 0 },			/* 32 = gtty */
	{ 2, s(struct linux_sys_access_args) },			/* 33 = access */
	{ 1, s(struct linux_sys_nice_args) },			/* 34 = nice */
	{ 0, 0 },			/* 35 = ftime */
	{ 0, 0 },				/* 36 = sync */
	{ 2, s(struct linux_sys_kill_args) },			/* 37 = kill */
	{ 2, s(struct linux_sys_rename_args) },			/* 38 = rename */
	{ 2, s(struct linux_sys_mkdir_args) },			/* 39 = mkdir */
	{ 1, s(struct linux_sys_rmdir_args) },			/* 40 = rmdir */
	{ 1, s(struct sys_dup_args) },				/* 41 = dup */
	{ 1, s(struct linux_sys_pipe_args) },			/* 42 = pipe */
	{ 1, s(struct linux_sys_times_args) },			/* 43 = times */
	{ 0, 0 },			/* 44 = prof */
	{ 1, s(struct linux_sys_brk_args) },			/* 45 = brk */
	{ 1, s(struct sys_setgid_args) },			/* 46 = linux_setgid16 */
	{ 0, 0 },			/* 47 = linux_getgid16 */
	{ 2, s(struct linux_sys_signal_args) },			/* 48 = signal */
	{ 0, 0 },			/* 49 = linux_geteuid16 */
	{ 0, 0 },			/* 50 = linux_getegid16 */
	{ 1, s(struct sys_acct_args) },				/* 51 = acct */
	{ 0, 0 },			/* 52 = phys */
	{ 0, 0 },			/* 53 = lock */
	{ 3, s(struct linux_sys_ioctl_args) },			/* 54 = ioctl */
	{ 3, s(struct linux_sys_fcntl_args) },			/* 55 = fcntl */
	{ 0, 0 },			/* 56 = mpx */
	{ 2, s(struct sys_setpgid_args) },			/* 57 = setpgid */
	{ 0, 0 },			/* 58 = ulimit */
	{ 1, s(struct linux_sys_oldolduname_args) },		/* 59 = oldolduname */
	{ 1, s(struct sys_umask_args) },			/* 60 = umask */
	{ 1, s(struct sys_chroot_args) },			/* 61 = chroot */
	{ 0, 0 },			/* 62 = ustat */
	{ 2, s(struct sys_dup2_args) },				/* 63 = dup2 */
	{ 0, 0 },			/* 64 = getppid */
	{ 0, 0 },			/* 65 = getpgrp */
	{ 0, 0 },			/* 66 = setsid */
	{ 3, s(struct linux_sys_sigaction_args) },		/* 67 = sigaction */
	{ 0, 0 },		/* 68 = siggetmask */
	{ 1, s(struct linux_sys_sigsetmask_args) },		/* 69 = sigsetmask */
	{ 2, s(struct linux_sys_setreuid16_args) },		/* 70 = setreuid16 */
	{ 2, s(struct linux_sys_setregid16_args) },		/* 71 = setregid16 */
	{ 3, s(struct linux_sys_sigsuspend_args) },		/* 72 = sigsuspend */
	{ 1, s(struct linux_sys_sigpending_args) },		/* 73 = sigpending */
	{ 2, s(struct compat_43_sys_sethostname_args) },	/* 74 = sethostname */
	{ 2, s(struct linux_sys_setrlimit_args) },		/* 75 = setrlimit */
	{ 2, s(struct linux_sys_getrlimit_args) },		/* 76 = getrlimit */
	{ 2, s(struct sys_getrusage_args) },			/* 77 = getrusage */
	{ 2, s(struct sys_gettimeofday_args) },			/* 78 = gettimeofday */
	{ 2, s(struct sys_settimeofday_args) },			/* 79 = settimeofday */
	{ 2, s(struct sys_getgroups_args) },			/* 80 = linux_getgroups */
	{ 2, s(struct sys_setgroups_args) },			/* 81 = linux_setgroups */
	{ 1, s(struct linux_sys_oldselect_args) },		/* 82 = oldselect */
	{ 2, s(struct linux_sys_symlink_args) },		/* 83 = symlink */
	{ 2, s(struct compat_43_sys_lstat_args) },		/* 84 = olstat */
	{ 3, s(struct linux_sys_readlink_args) },		/* 85 = readlink */
	{ 1, s(struct linux_sys_uselib_args) },			/* 86 = uselib */
	{ 1, s(struct sys_swapon_args) },			/* 87 = swapon */
	{ 1, s(struct sys_reboot_args) },			/* 88 = reboot */
	{ 3, s(struct linux_sys_readdir_args) },		/* 89 = readdir */
	{ 1, s(struct linux_sys_mmap_args) },			/* 90 = mmap */
	{ 2, s(struct sys_munmap_args) },			/* 91 = munmap */
	{ 2, s(struct linux_sys_truncate_args) },		/* 92 = truncate */
	{ 2, s(struct compat_43_sys_ftruncate_args) },		/* 93 = ftruncate */
	{ 2, s(struct sys_fchmod_args) },			/* 94 = fchmod */
	{ 3, s(struct linux_sys_fchown16_args) },		/* 95 = fchown16 */
	{ 2, s(struct sys_getpriority_args) },			/* 96 = getpriority */
	{ 3, s(struct sys_setpriority_args) },			/* 97 = setpriority */
	{ 4, s(struct sys_profil_args) },			/* 98 = profil */
	{ 2, s(struct linux_sys_statfs_args) },			/* 99 = statfs */
	{ 2, s(struct linux_sys_fstatfs_args) },		/* 100 = fstatfs */
#ifdef __i386__
	{ 3, s(struct linux_sys_ioperm_args) },			/* 101 = ioperm */
#else
	{ 0, 0 },			/* 101 = ioperm */
#endif
	{ 2, s(struct linux_sys_socketcall_args) },		/* 102 = socketcall */
	{ 0, 0 },			/* 103 = klog */
	{ 3, s(struct sys_setitimer_args) },			/* 104 = setitimer */
	{ 2, s(struct sys_getitimer_args) },			/* 105 = getitimer */
	{ 2, s(struct linux_sys_stat_args) },			/* 106 = stat */
	{ 2, s(struct linux_sys_lstat_args) },			/* 107 = lstat */
	{ 2, s(struct linux_sys_fstat_args) },			/* 108 = fstat */
	{ 1, s(struct linux_sys_olduname_args) },		/* 109 = olduname */
#ifdef __i386__
	{ 1, s(struct linux_sys_iopl_args) },			/* 110 = iopl */
#else
	{ 0, 0 },			/* 110 = iopl */
#endif
	{ 0, 0 },		/* 111 = vhangup */
	{ 0, 0 },			/* 112 = idle */
	{ 0, 0 },		/* 113 = vm86old */
	{ 4, s(struct linux_sys_wait4_args) },			/* 114 = wait4 */
	{ 0, 0 },		/* 115 = swapoff */
	{ 0, 0 },		/* 116 = sysinfo */
	{ 5, s(struct linux_sys_ipc_args) },			/* 117 = ipc */
	{ 1, s(struct sys_fsync_args) },			/* 118 = fsync */
	{ 1, s(struct linux_sys_sigreturn_args) },		/* 119 = sigreturn */
	{ 2, s(struct linux_sys_clone_args) },			/* 120 = clone */
	{ 2, s(struct compat_09_sys_setdomainname_args) },	/* 121 = setdomainname */
	{ 1, s(struct linux_sys_uname_args) },			/* 122 = uname */
#ifdef __i386__
	{ 3, s(struct linux_sys_modify_ldt_args) },		/* 123 = modify_ldt */
#else
	{ 0, 0 },		/* 123 = modify_ldt */
#endif
	{ 0, 0 },		/* 124 = adjtimex */
	{ 3, s(struct sys_mprotect_args) },			/* 125 = mprotect */
	{ 3, s(struct linux_sys_sigprocmask_args) },		/* 126 = sigprocmask */
	{ 0, 0 },		/* 127 = create_module */
	{ 0, 0 },		/* 128 = init_module */
	{ 0, 0 },		/* 129 = delete_module */
	{ 0, 0 },	/* 130 = get_kernel_syms */
	{ 0, 0 },		/* 131 = quotactl */
	{ 1, s(struct linux_sys_getpgid_args) },		/* 132 = getpgid */
	{ 1, s(struct sys_fchdir_args) },			/* 133 = fchdir */
	{ 0, 0 },		/* 134 = bdflush */
	{ 0, 0 },			/* 135 = sysfs */
	{ 1, s(struct linux_sys_personality_args) },		/* 136 = personality */
	{ 0, 0 },		/* 137 = afs_syscall */
	{ 1, s(struct linux_sys_setfsuid_args) },		/* 138 = linux_setfsuid16 */
	{ 0, 0 },		/* 139 = linux_getfsuid16 */
	{ 5, s(struct linux_sys_llseek_args) },			/* 140 = llseek */
	{ 3, s(struct linux_sys_getdents_args) },		/* 141 = getdents */
	{ 5, s(struct linux_sys_select_args) },			/* 142 = select */
	{ 2, s(struct sys_flock_args) },			/* 143 = flock */
	{ 3, s(struct sys_msync_args) },			/* 144 = msync */
	{ 3, s(struct sys_readv_args) },			/* 145 = readv */
	{ 3, s(struct sys_writev_args) },			/* 146 = writev */
	{ 1, s(struct linux_sys_getsid_args) },			/* 147 = getsid */
	{ 1, s(struct linux_sys_fdatasync_args) },		/* 148 = fdatasync */
	{ 1, s(struct linux_sys___sysctl_args) },		/* 149 = __sysctl */
	{ 2, s(struct sys_mlock_args) },			/* 150 = mlock */
	{ 2, s(struct sys_munlock_args) },			/* 151 = munlock */
	{ 0, 0 },		/* 152 = mlockall */
	{ 0, 0 },		/* 153 = munlockall */
	{ 2, s(struct linux_sys_sched_setparam_args) },		/* 154 = sched_setparam */
	{ 2, s(struct linux_sys_sched_getparam_args) },		/* 155 = sched_getparam */
	{ 3, s(struct linux_sys_sched_setscheduler_args) },	/* 156 = sched_setscheduler */
	{ 1, s(struct linux_sys_sched_getscheduler_args) },	/* 157 = sched_getscheduler */
	{ 0, 0 },		/* 158 = sched_yield */
	{ 1, s(struct linux_sys_sched_get_priority_max_args) },	/* 159 = sched_get_priority_max */
	{ 1, s(struct linux_sys_sched_get_priority_min_args) },	/* 160 = sched_get_priority_min */
	{ 0, 0 },	/* 161 = sched_rr_get_interval */
	{ 2, s(struct sys_nanosleep_args) },			/* 162 = nanosleep */
	{ 4, s(struct linux_sys_mremap_args) },			/* 163 = mremap */
	{ 3, s(struct linux_sys_setresuid16_args) },		/* 164 = setresuid16 */
	{ 3, s(struct linux_sys_getresuid_args) },		/* 165 = linux_getresuid16 */
	{ 0, 0 },			/* 166 = vm86 */
	{ 0, 0 },		/* 167 = query_module */
	{ 3, s(struct sys_poll_args) },				/* 168 = poll */
	{ 0, 0 },		/* 169 = nfsservctl */
	{ 3, s(struct linux_sys_setresgid16_args) },		/* 170 = setresgid16 */
	{ 3, s(struct linux_sys_getresgid16_args) },		/* 171 = getresgid16 */
	{ 0, 0 },			/* 172 = prctl */
	{ 1, s(struct linux_sys_rt_sigreturn_args) },	/* 173 = rt_sigreturn */
	{ 4, s(struct linux_sys_rt_sigaction_args) },	/* 174 = rt_sigaction */
	{ 4, s(struct linux_sys_rt_sigprocmask_args) },	/* 175 = rt_sigprocmask */
	{ 2, s(struct linux_sys_rt_sigpending_args) },	/* 176 = rt_sigpending */
	{ 0, 0 },	/* 177 = rt_sigtimedwait */
	{ 0, 0 },		/* 178 = rt_queueinfo */
	{ 2, s(struct linux_sys_rt_sigsuspend_args) },	/* 179 = rt_sigsuspend */
	{ 4, s(struct linux_sys_pread_args) },		/* 180 = pread */
	{ 4, s(struct linux_sys_pwrite_args) },		/* 181 = pwrite */
	{ 3, s(struct linux_sys_chown16_args) },	/* 182 = chown16 */
	{ 2, s(struct linux_sys_getcwd_args) },		/* 183 = getcwd */
	{ 0, 0 },			/* 184 = capget */
	{ 0, 0 },			/* 185 = capset */
	{ 2, s(struct linux_sys_sigaltstack_args) },	/* 186 = sigaltstack */
	{ 0, 0 },		/* 187 = sendfile */
	{ 0, 0 },		/* 188 = getpmsg */
	{ 0, 0 },		/* 189 = putpmsg */
	{ 0, 0 },			/* 190 = vfork */
	{ 2, s(struct linux_sys_ugetrlimit_args) },	/* 191 = ugetrlimit */
	{ 0, 0 },			/* 192 = mmap2 */
	{ 2, s(struct linux_sys_truncate64_args) },	/* 193 = truncate64 */
	{ 2, s(struct sys_ftruncate_args) },		/* 194 = linux_ftruncate64 */
	{ 2, s(struct linux_sys_stat64_args) },		/* 195 = stat64 */
	{ 2, s(struct linux_sys_lstat64_args) },	/* 196 = lstat64 */
	{ 2, s(struct linux_sys_fstat64_args) },	/* 197 = fstat64 */
	{ 0, 0 },			/* 198 = lchown */
	{ 0, 0 },			/* 199 = getuid */
	{ 0, 0 },			/* 200 = getgid */
	{ 0, 0 },			/* 201 = geteuid */
	{ 0, 0 },			/* 202 = getegid */
	{ 0, 0 },		/* 203 = setreuid */
	{ 0, 0 },		/* 204 = setregid */
	{ 2, s(struct sys_getgroups_args) },		/* 205 = getgroups */
	{ 2, s(struct sys_setgroups_args) },		/* 206 = setgroups */
	{ 0, 0 },			/* 207 = fchown */
	{ 0, 0 },		/* 208 = setresuid */
	{ 3, s(struct linux_sys_getresuid_args) },	/* 209 = getresuid */
	{ 0, 0 },		/* 210 = setresgid */
	{ 0, 0 },		/* 211 = getresgid */
	{ 0, 0 },			/* 212 = chown */
	{ 1, s(struct sys_setuid_args) },	/* 213 = setuid */
	{ 1, s(struct sys_setgid_args) },	/* 214 = setgid */
	{ 1, s(struct linux_sys_setfsuid_args) },		/* 215 = setfsuid */
	{ 0, 0 },		/* 216 = setfsgid */
	{ 0, 0 },		/* 217 = pivot_root */
	{ 0, 0 },		/* 218 = mincore */
	{ 0, 0 },		/* 219 = madvise */
	{ 0, 0 },		/* 220 = getdents64 */
	{ 3, s(struct linux_sys_fcntl64_args) },		/* 221 = fcntl64 */
	/* XXX These need to be filled out */
	{ 0, 0 },		/* 222 */  
	{ 0, 0 },		/* 223 */
	{ 0, 0 },		/* 224 */
	{ 0, 0 },		/* 225 */
	{ 0, 0 },		/* 226 */
	{ 0, 0 },		/* 227 */
	{ 0, 0 },		/* 228 */
	{ 0, 0 },		/* 229 */
	{ 0, 0 },		/* 230 */
	{ 0, 0 },		/* 231 */
	{ 0, 0 },		/* 232 */
	{ 0, 0 },		/* 233 */
	{ 0, 0 },		/* 234 */
	{ 0, 0 },		/* 235 */
	{ 0, 0 },		/* 236 */
	{ 0, 0 },		/* 237 */
	{ 0, 0 },		/* 238 */
	{ 0, 0 },		/* 239 */
	{ 0, 0 },		/* 240 */
	{ 0, 0 },		/* 241 */
	{ 0, 0 },		/* 242 */
	{ 0, 0 },		/* 243 */
	{ 0, 0 },		/* 244 */
	{ 0, 0 },		/* 245 */
	{ 0, 0 },		/* 246 */
	{ 0, 0 },		/* 247 */
	{ 0, 0 },		/* 248 */
	{ 0, 0 },		/* 249 */
	{ 0, 0 },		/* 250 */
	{ 0, 0 },		/* 251 */
	{ 0, 0 },		/* 252 */
	{ 0, 0 },		/* 253 */
	{ 0, 0 },		/* 254 */
	{ 0, 0 },		/* 255 */
	{ 0, 0 },		/* 256 */
};
