/*
 * $Id: base64.c, base64 codec for filenames
 */

#include "base64.h"

/* bin => b64 table */
static	char b64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";
/* b64 => bin table */
static	int tab64[256] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x00,0x00,
	0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,0x05,0x06,
	0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,
	0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x00,0x00,0x00,0x00,0x3e,
	0x00,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,0x21,0x22,0x23,0x24,
	0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x30,
	0x31,0x32,0x33 };


/* encode binary string to base64 */
int	base64_encode(const unsigned char *data, unsigned char *out, int len)
{
	register int	i, j, a1 = 0, k;
	for (i = 0, j = 0, k = 0; i < len; i++) {
		switch (k) {

			case 0:
				a1 = b64[(data[i] & 0x3f)];
				break;
			case 1:
				out[j++] = a1;
				out[j++] = b64[(data[i-1] >> 6) | ((data[i] & 0xf) << 2)];
				break;
			case 2:
				out[j++] = b64[(data[i-1] >> 4 | ((data[i] & 0x3) << 4))];
				out[j++] = b64[(data[i] >> 2)];
				k = 0;
				continue;
				
		}
		k++;

	}
	if (k == 1) {
		out[j++] = a1;
		out[j++] = b64[(data[i-1] >> 6)];
	}
	if (k == 2) {
		out[j++] = b64[(data[i-1] >> 4)];
	}
	return j;
}

int	base64_decode(const unsigned char *data, unsigned char *out, int len)
{
	register	int i, j;
	for (i = j = 0; i < len; i++) {
		register int val = (int) tab64[(int)data[i]];
		switch (i & 3) {
			case 0:
				out[j++] = val;
				break;
			case 1:
				out[j-1] |= (val & 3) << 6;
				out[j++] = (val >> 2);
				break;
			case 2:
				out[j-1] |= (val & 0xf) << 4;
				out[j++] = (val >> 4);
				break;
			case 3:
				out[j-1] |= val << 2;
				break;
		}
	}
	return j;
}


