/* resource handling routines (c) Brad Spengler 2002, 2003 */

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/gracl.h>
#include <linux/grinternal.h>

static const char *restab_log[11] = {
	"RLIMIT_CPU",
	"RLIMIT_FSIZE",
	"RLIMIT_DATA",
	"RLIMIT_STACK",
	"RLIMIT_CORE",
	"RLIMIT_RSS",
	"RLIMIT_NPROC",
	"RLIMIT_NOFILE",
	"RLIMIT_MEMLOCK",
	"RLIMIT_AS",
	"RLIMIT_LOCKS"
};

__inline__ void
gr_log_resource(const struct task_struct *task,
		const int res, const unsigned long wanted, const int gt)
{
	if (unlikely(res == RLIMIT_NPROC && 
	    (cap_raised(task->cap_effective, CAP_SYS_ADMIN) || 
	     cap_raised(task->cap_effective, CAP_SYS_RESOURCE))))
		return;

	if (!((grsec_enable_resourcelog && grsec_enable_group &&
	       in_group_p(grsec_audit_gid))
	      || (grsec_enable_resourcelog && !grsec_enable_group)))
		return;


	preempt_disable();

	if (unlikely(((gt && wanted > task->rlim[res].rlim_cur) ||
		      (!gt && wanted >= task->rlim[res].rlim_cur)) &&
		     task->rlim[res].rlim_cur != RLIM_INFINITY))
		security_alert(GR_RESOURCE_MSG, wanted, restab_log[res],
			       task->rlim[res].rlim_cur,
			       gr_task_fullpath(task), task->comm,
			       task->pid, task->uid, task->euid,
			       task->gid, task->egid,
			       gr_parent_task_fullpath(task),
			       task->p_pptr->comm,
			       task->p_pptr->pid, task->p_pptr->uid, 
			       task->p_pptr->euid, task->p_pptr->gid,
			       task->p_pptr->egid);

	preempt_enable_no_resched();

	return;
}
