/*
 * Copyright (C) 2012-2013  Renesas Solutions Corp.
 * Copyright (C) 2013  Magnus Damm
 * Copyright (C) 2012  Kuninori Morimoto <kuninori.morimoto.gx@renesas.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/pinctrl/pinconf-generic.h>

#include "core.h"
#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, pfx, sfx)					\
	/*  Port0 - Port30 */						\
	PORT_10(0, fn, pfx, sfx),					\
	PORT_10(10, fn, pfx##1, sfx),					\
	PORT_10(20, fn, pfx##2, sfx),					\
	PORT_1(30, fn, pfx##30, sfx),					\
	/* Port32 - Port40 */						\
	PORT_1(32, fn, pfx##32, sfx),	PORT_1(33, fn, pfx##33, sfx),	\
	PORT_1(34, fn, pfx##34, sfx),	PORT_1(35, fn, pfx##35, sfx),	\
	PORT_1(36, fn, pfx##36, sfx),	PORT_1(37, fn, pfx##37, sfx),	\
	PORT_1(38, fn, pfx##38, sfx),	PORT_1(39, fn, pfx##39, sfx),	\
	PORT_1(40, fn, pfx##40, sfx),					\
	/* Port64  - Port85 */						\
	PORT_1(64, fn, pfx##64, sfx),	PORT_1(65, fn, pfx##65, sfx),	\
	PORT_1(66, fn, pfx##66, sfx),	PORT_1(67, fn, pfx##67, sfx),	\
	PORT_1(68, fn, pfx##68, sfx),	PORT_1(69, fn, pfx##69, sfx),	\
	PORT_10(70, fn, pfx##7, sfx),					\
	PORT_1(80, fn, pfx##80, sfx),	PORT_1(81, fn, pfx##81, sfx),	\
	PORT_1(82, fn, pfx##82, sfx),	PORT_1(83, fn, pfx##83, sfx),	\
	PORT_1(84, fn, pfx##84, sfx),	PORT_1(85, fn, pfx##85, sfx),	\
	/* Port96  - Port126 */						\
	PORT_1(96, fn, pfx##96, sfx),	PORT_1(97, fn, pfx##97, sfx),	\
	PORT_1(98, fn, pfx##98, sfx),	PORT_1(99, fn, pfx##99, sfx),	\
	PORT_10(100, fn, pfx##10, sfx),					\
	PORT_10(110, fn, pfx##11, sfx),					\
	PORT_1(120, fn, pfx##120, sfx),	PORT_1(121, fn, pfx##121, sfx),	\
	PORT_1(122, fn, pfx##122, sfx),	PORT_1(123, fn, pfx##123, sfx),	\
	PORT_1(124, fn, pfx##124, sfx),	PORT_1(125, fn, pfx##125, sfx),	\
	PORT_1(126, fn, pfx##126, sfx),					\
	/* Port128 - Port134 */						\
	PORT_1(128, fn, pfx##128, sfx),	PORT_1(129, fn, pfx##129, sfx),	\
	PORT_1(130, fn, pfx##130, sfx),	PORT_1(131, fn, pfx##131, sfx),	\
	PORT_1(132, fn, pfx##132, sfx),	PORT_1(133, fn, pfx##133, sfx),	\
	PORT_1(134, fn, pfx##134, sfx),					\
	/* Port160 - Port178 */						\
	PORT_10(160, fn, pfx##16, sfx),					\
	PORT_1(170, fn, pfx##170, sfx),	PORT_1(171, fn, pfx##171, sfx),	\
	PORT_1(172, fn, pfx##172, sfx),	PORT_1(173, fn, pfx##173, sfx),	\
	PORT_1(174, fn, pfx##174, sfx),	PORT_1(175, fn, pfx##175, sfx),	\
	PORT_1(176, fn, pfx##176, sfx),	PORT_1(177, fn, pfx##177, sfx),	\
	PORT_1(178, fn, pfx##178, sfx),					\
	/* Port192 - Port222 */						\
	PORT_1(192, fn, pfx##192, sfx),	PORT_1(193, fn, pfx##193, sfx),	\
	PORT_1(194, fn, pfx##194, sfx),	PORT_1(195, fn, pfx##195, sfx),	\
	PORT_1(196, fn, pfx##196, sfx),	PORT_1(197, fn, pfx##197, sfx),	\
	PORT_1(198, fn, pfx##198, sfx),	PORT_1(199, fn, pfx##199, sfx),	\
	PORT_10(200, fn, pfx##20, sfx),					\
	PORT_10(210, fn, pfx##21, sfx),					\
	PORT_1(220, fn, pfx##220, sfx),	PORT_1(221, fn, pfx##221, sfx),	\
	PORT_1(222, fn, pfx##222, sfx),					\
	/* Port224 - Port250 */						\
	PORT_1(224, fn, pfx##224, sfx),	PORT_1(225, fn, pfx##225, sfx),	\
	PORT_1(226, fn, pfx##226, sfx),	PORT_1(227, fn, pfx##227, sfx),	\
	PORT_1(228, fn, pfx##228, sfx),	PORT_1(229, fn, pfx##229, sfx),	\
	PORT_10(230, fn, pfx##23, sfx),					\
	PORT_10(240, fn, pfx##24, sfx),					\
	PORT_1(250, fn, pfx##250, sfx),					\
	/* Port256 - Port283 */						\
	PORT_1(256, fn, pfx##256, sfx),	PORT_1(257, fn, pfx##257, sfx),	\
	PORT_1(258, fn, pfx##258, sfx),	PORT_1(259, fn, pfx##259, sfx),	\
	PORT_10(260, fn, pfx##26, sfx),					\
	PORT_10(270, fn, pfx##27, sfx),					\
	PORT_1(280, fn, pfx##280, sfx),	PORT_1(281, fn, pfx##281, sfx),	\
	PORT_1(282, fn, pfx##282, sfx),	PORT_1(283, fn, pfx##283, sfx),	\
	/* Port288 - Port308 */						\
	PORT_1(288, fn, pfx##288, sfx),	PORT_1(289, fn, pfx##289, sfx),	\
	PORT_10(290, fn, pfx##29, sfx),					\
	PORT_1(300, fn, pfx##300, sfx),	PORT_1(301, fn, pfx##301, sfx),	\
	PORT_1(302, fn, pfx##302, sfx),	PORT_1(303, fn, pfx##303, sfx),	\
	PORT_1(304, fn, pfx##304, sfx),	PORT_1(305, fn, pfx##305, sfx),	\
	PORT_1(306, fn, pfx##306, sfx),	PORT_1(307, fn, pfx##307, sfx),	\
	PORT_1(308, fn, pfx##308, sfx),					\
	/* Port320 - Port329 */						\
	PORT_10(320, fn, pfx##32, sfx)


enum {
	PINMUX_RESERVED = 0,

	/* PORT0_DATA -> PORT329_DATA */
	PINMUX_DATA_BEGIN,
	PORT_ALL(DATA),
	PINMUX_DATA_END,

	/* PORT0_IN -> PORT329_IN */
	PINMUX_INPUT_BEGIN,
	PORT_ALL(IN),
	PINMUX_INPUT_END,

	/* PORT0_OUT -> PORT329_OUT */
	PINMUX_OUTPUT_BEGIN,
	PORT_ALL(OUT),
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PORT_ALL(FN_IN), /* PORT0_FN_IN -> PORT329_FN_IN */
	PORT_ALL(FN_OUT), /* PORT0_FN_OUT -> PORT329_FN_OUT */
	PORT_ALL(FN0), /* PORT0_FN0 -> PORT329_FN0 */
	PORT_ALL(FN1), /* PORT0_FN1 -> PORT329_FN1 */
	PORT_ALL(FN2), /* PORT0_FN2 -> PORT329_FN2 */
	PORT_ALL(FN3), /* PORT0_FN3 -> PORT329_FN3 */
	PORT_ALL(FN4), /* PORT0_FN4 -> PORT329_FN4 */
	PORT_ALL(FN5), /* PORT0_FN5 -> PORT329_FN5 */
	PORT_ALL(FN6), /* PORT0_FN6 -> PORT329_FN6 */
	PORT_ALL(FN7), /* PORT0_FN7 -> PORT329_FN7 */

	MSEL1CR_31_0, MSEL1CR_31_1,
	MSEL1CR_27_0, MSEL1CR_27_1,
	MSEL1CR_25_0, MSEL1CR_25_1,
	MSEL1CR_24_0, MSEL1CR_24_1,
	MSEL1CR_22_0, MSEL1CR_22_1,
	MSEL1CR_21_0, MSEL1CR_21_1,
	MSEL1CR_20_0, MSEL1CR_20_1,
	MSEL1CR_19_0, MSEL1CR_19_1,
	MSEL1CR_18_0, MSEL1CR_18_1,
	MSEL1CR_17_0, MSEL1CR_17_1,
	MSEL1CR_16_0, MSEL1CR_16_1,
	MSEL1CR_15_0, MSEL1CR_15_1,
	MSEL1CR_14_0, MSEL1CR_14_1,
	MSEL1CR_13_0, MSEL1CR_13_1,
	MSEL1CR_12_0, MSEL1CR_12_1,
	MSEL1CR_11_0, MSEL1CR_11_1,
	MSEL1CR_10_0, MSEL1CR_10_1,
	MSEL1CR_09_0, MSEL1CR_09_1,
	MSEL1CR_08_0, MSEL1CR_08_1,
	MSEL1CR_07_0, MSEL1CR_07_1,
	MSEL1CR_06_0, MSEL1CR_06_1,
	MSEL1CR_05_0, MSEL1CR_05_1,
	MSEL1CR_04_0, MSEL1CR_04_1,
	MSEL1CR_03_0, MSEL1CR_03_1,
	MSEL1CR_02_0, MSEL1CR_02_1,
	MSEL1CR_01_0, MSEL1CR_01_1,
	MSEL1CR_00_0, MSEL1CR_00_1,

	MSEL3CR_31_0, MSEL3CR_31_1,
	MSEL3CR_28_0, MSEL3CR_28_1,
	MSEL3CR_27_0, MSEL3CR_27_1,
	MSEL3CR_26_0, MSEL3CR_26_1,
	MSEL3CR_23_0, MSEL3CR_23_1,
	MSEL3CR_22_0, MSEL3CR_22_1,
	MSEL3CR_21_0, MSEL3CR_21_1,
	MSEL3CR_20_0, MSEL3CR_20_1,
	MSEL3CR_19_0, MSEL3CR_19_1,
	MSEL3CR_18_0, MSEL3CR_18_1,
	MSEL3CR_17_0, MSEL3CR_17_1,
	MSEL3CR_16_0, MSEL3CR_16_1,
	MSEL3CR_15_0, MSEL3CR_15_1,
	MSEL3CR_12_0, MSEL3CR_12_1,
	MSEL3CR_11_0, MSEL3CR_11_1,
	MSEL3CR_10_0, MSEL3CR_10_1,
	MSEL3CR_09_0, MSEL3CR_09_1,
	MSEL3CR_06_0, MSEL3CR_06_1,
	MSEL3CR_03_0, MSEL3CR_03_1,
	MSEL3CR_01_0, MSEL3CR_01_1,
	MSEL3CR_00_0, MSEL3CR_00_1,

	MSEL4CR_30_0, MSEL4CR_30_1,
	MSEL4CR_29_0, MSEL4CR_29_1,
	MSEL4CR_28_0, MSEL4CR_28_1,
	MSEL4CR_27_0, MSEL4CR_27_1,
	MSEL4CR_26_0, MSEL4CR_26_1,
	MSEL4CR_25_0, MSEL4CR_25_1,
	MSEL4CR_24_0, MSEL4CR_24_1,
	MSEL4CR_23_0, MSEL4CR_23_1,
	MSEL4CR_22_0, MSEL4CR_22_1,
	MSEL4CR_21_0, MSEL4CR_21_1,
	MSEL4CR_20_0, MSEL4CR_20_1,
	MSEL4CR_19_0, MSEL4CR_19_1,
	MSEL4CR_18_0, MSEL4CR_18_1,
	MSEL4CR_17_0, MSEL4CR_17_1,
	MSEL4CR_16_0, MSEL4CR_16_1,
	MSEL4CR_15_0, MSEL4CR_15_1,
	MSEL4CR_14_0, MSEL4CR_14_1,
	MSEL4CR_13_0, MSEL4CR_13_1,
	MSEL4CR_12_0, MSEL4CR_12_1,
	MSEL4CR_11_0, MSEL4CR_11_1,
	MSEL4CR_10_0, MSEL4CR_10_1,
	MSEL4CR_09_0, MSEL4CR_09_1,
	MSEL4CR_07_0, MSEL4CR_07_1,
	MSEL4CR_04_0, MSEL4CR_04_1,
	MSEL4CR_01_0, MSEL4CR_01_1,

	MSEL5CR_31_0, MSEL5CR_31_1,
	MSEL5CR_30_0, MSEL5CR_30_1,
	MSEL5CR_29_0, MSEL5CR_29_1,
	MSEL5CR_28_0, MSEL5CR_28_1,
	MSEL5CR_27_0, MSEL5CR_27_1,
	MSEL5CR_26_0, MSEL5CR_26_1,
	MSEL5CR_25_0, MSEL5CR_25_1,
	MSEL5CR_24_0, MSEL5CR_24_1,
	MSEL5CR_23_0, MSEL5CR_23_1,
	MSEL5CR_22_0, MSEL5CR_22_1,
	MSEL5CR_21_0, MSEL5CR_21_1,
	MSEL5CR_20_0, MSEL5CR_20_1,
	MSEL5CR_19_0, MSEL5CR_19_1,
	MSEL5CR_18_0, MSEL5CR_18_1,
	MSEL5CR_17_0, MSEL5CR_17_1,
	MSEL5CR_16_0, MSEL5CR_16_1,
	MSEL5CR_15_0, MSEL5CR_15_1,
	MSEL5CR_14_0, MSEL5CR_14_1,
	MSEL5CR_13_0, MSEL5CR_13_1,
	MSEL5CR_12_0, MSEL5CR_12_1,
	MSEL5CR_11_0, MSEL5CR_11_1,
	MSEL5CR_10_0, MSEL5CR_10_1,
	MSEL5CR_09_0, MSEL5CR_09_1,
	MSEL5CR_08_0, MSEL5CR_08_1,
	MSEL5CR_07_0, MSEL5CR_07_1,
	MSEL5CR_06_0, MSEL5CR_06_1,

	MSEL8CR_16_0, MSEL8CR_16_1,
	MSEL8CR_01_0, MSEL8CR_01_1,
	MSEL8CR_00_0, MSEL8CR_00_1,

	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,


#define F1(a)	a##_MARK
#define F2(a)	a##_MARK
#define F3(a)	a##_MARK
#define F4(a)	a##_MARK
#define F5(a)	a##_MARK
#define F6(a)	a##_MARK
#define F7(a)	a##_MARK
#define IRQ(a)	IRQ##a##_MARK

	F1(LCDD0), F3(PDM2_CLK_0), F7(DU0_DR0), IRQ(0), /* Port0 */
	F1(LCDD1), F3(PDM2_DATA_1), F7(DU0_DR19), IRQ(1),
	F1(LCDD2), F3(PDM3_CLK_2), F7(DU0_DR2), IRQ(2),
	F1(LCDD3), F3(PDM3_DATA_3), F7(DU0_DR3), IRQ(3),
	F1(LCDD4), F3(PDM4_CLK_4), F7(DU0_DR4), IRQ(4),
	F1(LCDD5), F3(PDM4_DATA_5), F7(DU0_DR5), IRQ(5),
	F1(LCDD6), F3(PDM0_OUTCLK_6), F7(DU0_DR6), IRQ(6),
	F1(LCDD7), F3(PDM0_OUTDATA_7), F7(DU0_DR7), IRQ(7),
	F1(LCDD8), F3(PDM1_OUTCLK_8), F7(DU0_DG0), IRQ(8),
	F1(LCDD9), F3(PDM1_OUTDATA_9), F7(DU0_DG1), IRQ(9),
	F1(LCDD10), F3(FSICCK), F7(DU0_DG2), IRQ(10), /* Port10 */
	F1(LCDD11), F3(FSICISLD), F7(DU0_DG3), IRQ(11),
	F1(LCDD12), F3(FSICOMC), F7(DU0_DG4), IRQ(12),
	F1(LCDD13), F3(FSICOLR), F4(FSICILR), F7(DU0_DG5), IRQ(13),
	F1(LCDD14), F3(FSICOBT), F4(FSICIBT), F7(DU0_DG6), IRQ(14),
	F1(LCDD15), F3(FSICOSLD), F7(DU0_DG7), IRQ(15),
	F1(LCDD16), F4(TPU1TO1), F7(DU0_DB0),
	F1(LCDD17), F4(SF_IRQ_00), F7(DU0_DB1),
	F1(LCDD18), F4(SF_IRQ_01), F7(DU0_DB2),
	F1(LCDD19), F3(SCIFB3_RTS_19), F7(DU0_DB3),
	F1(LCDD20), F3(SCIFB3_CTS_20), F7(DU0_DB4), /* Port20 */
	F1(LCDD21), F3(SCIFB3_TXD_21), F7(DU0_DB5),
	F1(LCDD22), F3(SCIFB3_RXD_22), F7(DU0_DB6),
	F1(LCDD23), F3(SCIFB3_SCK_23), F7(DU0_DB7),
	F1(LCDHSYN), F2(LCDCS), F3(SCIFB1_RTS_24),
	F7(DU0_EXHSYNC_N_CSYNC_N_HSYNC_N),
	F1(LCDVSYN), F3(SCIFB1_CTS_25), F7(DU0_EXVSYNC_N_VSYNC_N_CSYNC_N),
	F1(LCDDCK), F2(LCDWR), F3(SCIFB1_TXD_26), F7(DU0_DOTCLKIN),
	F1(LCDDISP), F2(LCDRS), F3(SCIFB1_RXD_27), F7(DU0_DOTCLKOUT),
	F1(LCDRD_N), F3(SCIFB1_SCK_28), F7(DU0_DOTCLKOUTB),
	F1(LCDLCLK), F4(SF_IRQ_02), F7(DU0_DISP_CSYNC_N_DE),
	F1(LCDDON), F4(SF_IRQ_03), F7(DU0_ODDF_N_CLAMP), /* Port30 */

	F1(SCIFA0_RTS), F5(SIM0_DET), F7(CSCIF0_RTS), /* Port32 */
	F1(SCIFA0_CTS), F5(SIM1_DET), F7(CSCIF0_CTS),
	F1(SCIFA0_SCK), F5(SIM0_PWRON), F7(CSCIF0_SCK),
	F1(SCIFA1_RTS), F7(CSCIF1_RTS),
	F1(SCIFA1_CTS), F7(CSCIF1_CTS),
	F1(SCIFA1_SCK), F7(CSCIF1_SCK),
	F1(SCIFB0_RTS), F3(TPU0TO1), F4(SCIFB3_RTS_38), F7(CHSCIF0_HRTS),
	F1(SCIFB0_CTS), F3(TPU0TO2), F4(SCIFB3_CTS_39), F7(CHSCIF0_HCTS),
	F1(SCIFB0_SCK), F3(TPU0TO3), F4(SCIFB3_SCK_40),
	F7(CHSCIF0_HSCK), /* Port40 */

	F1(PDM0_DATA), /* Port64 */
	F1(PDM1_DATA),
	F1(HSI_RX_WAKE), F2(SCIFB2_CTS_66), F3(MSIOF3_SYNC), F5(GenIO4),
	IRQ(40),
	F1(HSI_RX_READY), F2(SCIFB1_TXD_67), F5(GIO_OUT3_67), F7(CHSCIF1_HTX),
	F1(HSI_RX_FLAG), F2(SCIFB2_TXD_68), F3(MSIOF3_TXD), F5(GIO_OUT4_68),
	F1(HSI_RX_DATA), F2(SCIFB2_RXD_69), F3(MSIOF3_RXD), F5(GIO_OUT5_69),
	F1(HSI_TX_FLAG), F2(SCIFB1_RTS_70), F5(GIO_OUT1_70), F6(HSIC_TSTCLK0),
	F7(CHSCIF1_HRTS), /* Port70 */
	F1(HSI_TX_DATA), F2(SCIFB1_CTS_71), F5(GIO_OUT2_71), F6(HSIC_TSTCLK1),
	F7(CHSCIF1_HCTS),
	F1(HSI_TX_WAKE), F2(SCIFB1_RXD_72), F5(GenIO8), F7(CHSCIF1_HRX),
	F1(HSI_TX_READY), F2(SCIFB2_RTS_73), F3(MSIOF3_SCK), F5(GIO_OUT0_73),
	F1(IRDA_OUT), F1(IRDA_IN), F1(IRDA_FIRSEL), F1(TPU0TO0),
	F1(DIGRFEN), F1(GPS_TIMESTAMP), F1(TXP), /* Port80 */
	F1(TXP2), F1(COEX_0), F1(COEX_1), IRQ(19), IRQ(18), /* Port85 */

	F1(KEYIN0), /* Port96 */
	F1(KEYIN1), F1(KEYIN2), F1(KEYIN3), F1(KEYIN4), /* Port100 */
	F1(KEYIN5), F1(KEYIN6), IRQ(41), F1(KEYIN7), IRQ(42),
	F2(KEYOUT0), F2(KEYOUT1), F2(KEYOUT2), F2(KEYOUT3),
	F2(KEYOUT4), F2(KEYOUT5), IRQ(43), F2(KEYOUT6), IRQ(44), /* Port110 */
	F2(KEYOUT7), F5(RFANAEN), IRQ(45),
	F1(KEYIN8), F2(KEYOUT8), F4(SF_IRQ_04), IRQ(46),
	F1(KEYIN9), F2(KEYOUT9), F4(SF_IRQ_05), IRQ(47),
	F1(KEYIN10), F2(KEYOUT10), F4(SF_IRQ_06), IRQ(48),
	F1(KEYIN11), F2(KEYOUT11), F4(SF_IRQ_07), IRQ(49),
	F1(SCIFA0_TXD), F7(CSCIF0_TX), F1(SCIFA0_RXD), F7(CSCIF0_RX),
	F1(SCIFA1_TXD), F7(CSCIF1_TX), F1(SCIFA1_RXD), F7(CSCIF1_RX),
	F3(SF_PORT_1_120), F4(SCIFB3_RXD_120), F7(DU0_CDE), /* Port120 */
	F3(SF_PORT_0_121), F4(SCIFB3_TXD_121),
	F1(SCIFB0_TXD), F7(CHSCIF0_HTX),
	F1(SCIFB0_RXD), F7(CHSCIF0_HRX), F3(ISP_STROBE_124),
	F1(STP_ISD_0), F2(PDM4_CLK_125), F3(MSIOF2_TXD), F5(SIM0_VOLTSEL0),
	F1(TS_SDEN), F2(MSIOF7_SYNC), F3(STP_ISEN_1),
	F1(STP_ISEN_0), F2(PDM1_OUTDATA_128), F3(MSIOF2_SYNC),
	F5(SIM1_VOLTSEL1), F1(TS_SPSYNC), F2(MSIOF7_RXD), F3(STP_ISSYNC_1),
	F1(STP_ISSYNC_0), F2(PDM4_DATA_130), F3(MSIOF2_RXD),
	F5(SIM0_VOLTSEL1), /* Port130 */
	F1(STP_OPWM_0), F5(SIM1_PWRON), F1(TS_SCK), F2(MSIOF7_SCK),
	F3(STP_ISCLK_1), F1(STP_ISCLK_0), F2(PDM1_OUTCLK_133), F3(MSIOF2_SCK),
	F5(SIM1_VOLTSEL0), F1(TS_SDAT), F2(MSIOF7_TXD), F3(STP_ISD_1),
	IRQ(20), /* Port160 */
	IRQ(21), IRQ(22), IRQ(23),
	F1(MMCD0_0), F1(MMCD0_1), F1(MMCD0_2), F1(MMCD0_3),
	F1(MMCD0_4), F1(MMCD0_5), F1(MMCD0_6), /* Port170 */
	F1(MMCD0_7), F1(MMCCMD0), F1(MMCCLK0), F1(MMCRST),
	IRQ(24), IRQ(25), IRQ(26), IRQ(27),
	F1(A10), F2(MMCD1_7), IRQ(31), /* Port192 */
	F1(A9), F2(MMCD1_6), IRQ(32),
	F1(A8), F2(MMCD1_5), IRQ(33),
	F1(A7), F2(MMCD1_4), IRQ(34),
	F1(A6), F2(MMCD1_3), IRQ(35),
	F1(A5), F2(MMCD1_2), IRQ(36),
	F1(A4), F2(MMCD1_1), IRQ(37),
	F1(A3), F2(MMCD1_0), IRQ(38),
	F1(A2), F2(MMCCMD1), IRQ(39), /* Port200 */
	F1(A1),
	F1(A0), F2(BS),
	F1(CKO), F2(MMCCLK1),
	F1(CS0_N), F5(SIM0_GPO1),
	F1(CS2_N), F5(SIM0_GPO2),
	F1(CS4_N), F2(VIO_VD), F5(SIM1_GPO0),
	F1(D15), F5(GIO_OUT15),
	F1(D14), F5(GIO_OUT14),
	F1(D13), F5(GIO_OUT13),
	F1(D12), F5(GIO_OUT12), /* Port210 */
	F1(D11), F5(WGM_TXP2),
	F1(D10), F5(WGM_GPS_TIMEM_ASK_RFCLK),
	F1(D9), F2(VIO_D9), F5(GIO_OUT9),
	F1(D8), F2(VIO_D8), F5(GIO_OUT8),
	F1(D7), F2(VIO_D7), F5(GIO_OUT7),
	F1(D6), F2(VIO_D6), F5(GIO_OUT6),
	F1(D5), F2(VIO_D5), F5(GIO_OUT5_217),
	F1(D4), F2(VIO_D4), F5(GIO_OUT4_218),
	F1(D3), F2(VIO_D3), F5(GIO_OUT3_219),
	F1(D2), F2(VIO_D2), F5(GIO_OUT2_220), /* Port220 */
	F1(D1), F2(VIO_D1), F5(GIO_OUT1_221),
	F1(D0), F2(VIO_D0), F5(GIO_OUT0_222),
	F1(RDWR_224), F2(VIO_HD), F5(SIM1_GPO2),
	F1(RD_N), F1(WAIT_N), F2(VIO_CLK), F5(SIM1_GPO1),
	F1(WE0_N), F2(RDWR_227),
	F1(WE1_N), F5(SIM0_GPO0),
	F1(PWMO), F2(VIO_CKO1_229),
	F1(SLIM_CLK), F2(VIO_CKO4_230), /* Port230 */
	F1(SLIM_DATA), F2(VIO_CKO5_231), F2(VIO_CKO2_232), F4(SF_PORT_0_232),
	F2(VIO_CKO3_233), F4(SF_PORT_1_233),
	F1(FSIACK), F2(PDM3_CLK_234), F3(ISP_IRIS1_234),
	F1(FSIAISLD), F2(PDM3_DATA_235),
	F1(FSIAOMC), F2(PDM0_OUTCLK_236), F3(ISP_IRIS0_236),
	F1(FSIAOLR), F2(FSIAILR), F1(FSIAOBT), F2(FSIAIBT),
	F1(FSIAOSLD), F2(PDM0_OUTDATA_239),
	F1(FSIBISLD), /* Port240 */
	F1(FSIBOLR), F2(FSIBILR), F1(FSIBOMC), F3(ISP_SHUTTER1_242),
	F1(FSIBOBT), F2(FSIBIBT), F1(FSIBOSLD), F2(FSIASPDIF),
	F1(FSIBCK), F3(ISP_SHUTTER0_245),
	F1(ISP_IRIS1_246), F1(ISP_IRIS0_247), F1(ISP_SHUTTER1_248),
	F1(ISP_SHUTTER0_249), F1(ISP_STROBE_250), /* Port250 */
	F1(MSIOF0_SYNC), F1(MSIOF0_RXD), F1(MSIOF0_SCK), F1(MSIOF0_SS2),
	F3(VIO_CKO3_259), F1(MSIOF0_TXD), /* Port260 */
	F2(SCIFB1_SCK_261), F7(CHSCIF1_HSCK), F2(SCIFB2_SCK_262),
	F1(MSIOF1_SS2), F4(MSIOF5_SS2), F1(MSIOF1_TXD), F4(MSIOF5_TXD),
	F1(MSIOF1_RXD), F4(MSIOF5_RXD), F1(MSIOF1_SS1), F4(MSIOF5_SS1),
	F1(MSIOF0_SS1), F1(MSIOF1_SCK), F4(MSIOF5_SCK),
	F1(MSIOF1_SYNC), F4(MSIOF5_SYNC),
	F1(MSIOF2_SS1), F3(VIO_CKO5_270), /* Port270 */
	F1(MSIOF2_SS2), F3(VIO_CKO2_271), F1(MSIOF3_SS2), F3(VIO_CKO1_272),
	F1(MSIOF3_SS1), F3(VIO_CKO4_273), F1(MSIOF4_SS2), F4(TPU1TO0),
	F1(IC_DP), F1(SIM0_RST), F1(IC_DM), F1(SIM0_BSICOMP),
	F1(SIM0_CLK), F1(SIM0_IO), /* Port280 */
	F1(SIM1_IO), F2(PDM2_DATA_281), F1(SIM1_CLK), F2(PDM2_CLK_282),
	F1(SIM1_RST), F1(SDHID1_0), F3(STMDATA0_2),
	F1(SDHID1_1), F3(STMDATA1_2), IRQ(51), /* Port290 */
	F1(SDHID1_2), F3(STMDATA2_2), F1(SDHID1_3), F3(STMDATA3_2),
	F1(SDHICLK1), F3(STMCLK_2), F1(SDHICMD1), F3(STMSIDI_2),
	F1(SDHID2_0), F2(MSIOF4_TXD), F3(SCIFB2_TXD_295), F4(MSIOF6_TXD),
	F1(SDHID2_1), F4(MSIOF6_SS2), IRQ(52),
	F1(SDHID2_2), F2(MSIOF4_RXD), F3(SCIFB2_RXD_297), F4(MSIOF6_RXD),
	F1(SDHID2_3), F2(MSIOF4_SYNC), F3(SCIFB2_CTS_298), F4(MSIOF6_SYNC),
	F1(SDHICLK2), F2(MSIOF4_SCK), F3(SCIFB2_SCK_299), F4(MSIOF6_SCK),
	F1(SDHICMD2), F2(MSIOF4_SS1), F3(SCIFB2_RTS_300),
	F4(MSIOF6_SS1), /* Port300 */
	F1(SDHICD0), IRQ(50), F1(SDHID0_0), F3(STMDATA0_1),
	F1(SDHID0_1), F3(STMDATA1_1), F1(SDHID0_2), F3(STMDATA2_1),
	F1(SDHID0_3), F3(STMDATA3_1), F1(SDHICMD0), F3(STMSIDI_1),
	F1(SDHIWP0), F1(SDHICLK0), F3(STMCLK_1), IRQ(16), /* Port320 */
	IRQ(17), IRQ(28), IRQ(29), IRQ(30), IRQ(53), IRQ(54),
	IRQ(55), IRQ(56), IRQ(57),
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* specify valid pin states for each pin in GPIO mode */
	PINMUX_DATA_ALL(),

	/* Port0 */
	PINMUX_DATA(LCDD0_MARK,		PORT0_FN1),
	PINMUX_DATA(PDM2_CLK_0_MARK,	PORT0_FN3),
	PINMUX_DATA(DU0_DR0_MARK,	PORT0_FN7),
	PINMUX_DATA(IRQ0_MARK,		PORT0_FN0),

	/* Port1 */
	PINMUX_DATA(LCDD1_MARK,		PORT1_FN1),
	PINMUX_DATA(PDM2_DATA_1_MARK,	PORT1_FN3,	MSEL3CR_12_0),
	PINMUX_DATA(DU0_DR19_MARK,	PORT1_FN7),
	PINMUX_DATA(IRQ1_MARK,		PORT1_FN0),

	/* Port2 */
	PINMUX_DATA(LCDD2_MARK,		PORT2_FN1),
	PINMUX_DATA(PDM3_CLK_2_MARK,	PORT2_FN3),
	PINMUX_DATA(DU0_DR2_MARK,	PORT2_FN7),
	PINMUX_DATA(IRQ2_MARK,		PORT2_FN0),

	/* Port3 */
	PINMUX_DATA(LCDD3_MARK,		PORT3_FN1),
	PINMUX_DATA(PDM3_DATA_3_MARK,	PORT3_FN3,	MSEL3CR_12_0),
	PINMUX_DATA(DU0_DR3_MARK,	PORT3_FN7),
	PINMUX_DATA(IRQ3_MARK,		PORT3_FN0),

	/* Port4 */
	PINMUX_DATA(LCDD4_MARK,		PORT4_FN1),
	PINMUX_DATA(PDM4_CLK_4_MARK,	PORT4_FN3),
	PINMUX_DATA(DU0_DR4_MARK,	PORT4_FN7),
	PINMUX_DATA(IRQ4_MARK,		PORT4_FN0),

	/* Port5 */
	PINMUX_DATA(LCDD5_MARK,		PORT5_FN1),
	PINMUX_DATA(PDM4_DATA_5_MARK,	PORT5_FN3,	MSEL3CR_12_0),
	PINMUX_DATA(DU0_DR5_MARK,	PORT5_FN7),
	PINMUX_DATA(IRQ5_MARK,		PORT5_FN0),

	/* Port6 */
	PINMUX_DATA(LCDD6_MARK,		PORT6_FN1),
	PINMUX_DATA(PDM0_OUTCLK_6_MARK,	PORT6_FN3),
	PINMUX_DATA(DU0_DR6_MARK,	PORT6_FN7),
	PINMUX_DATA(IRQ6_MARK,		PORT6_FN0),

	/* Port7 */
	PINMUX_DATA(LCDD7_MARK,			PORT7_FN1),
	PINMUX_DATA(PDM0_OUTDATA_7_MARK,	PORT7_FN3),
	PINMUX_DATA(DU0_DR7_MARK,		PORT7_FN7),
	PINMUX_DATA(IRQ7_MARK,			PORT7_FN0),

	/* Port8 */
	PINMUX_DATA(LCDD8_MARK,		PORT8_FN1),
	PINMUX_DATA(PDM1_OUTCLK_8_MARK,	PORT8_FN3),
	PINMUX_DATA(DU0_DG0_MARK,	PORT8_FN7),
	PINMUX_DATA(IRQ8_MARK,		PORT8_FN0),

	/* Port9 */
	PINMUX_DATA(LCDD9_MARK,		PORT9_FN1),
	PINMUX_DATA(PDM1_OUTDATA_9_MARK, PORT9_FN3),
	PINMUX_DATA(DU0_DG1_MARK,	PORT9_FN7),
	PINMUX_DATA(IRQ9_MARK,		PORT9_FN0),

	/* Port10 */
	PINMUX_DATA(LCDD10_MARK,		PORT10_FN1),
	PINMUX_DATA(FSICCK_MARK,		PORT10_FN3),
	PINMUX_DATA(DU0_DG2_MARK,		PORT10_FN7),
	PINMUX_DATA(IRQ10_MARK,			PORT10_FN0),

	/* Port11 */
	PINMUX_DATA(LCDD11_MARK,		PORT11_FN1),
	PINMUX_DATA(FSICISLD_MARK,		PORT11_FN3),
	PINMUX_DATA(DU0_DG3_MARK,		PORT11_FN7),
	PINMUX_DATA(IRQ11_MARK,			PORT11_FN0),

	/* Port12 */
	PINMUX_DATA(LCDD12_MARK,		PORT12_FN1),
	PINMUX_DATA(FSICOMC_MARK,		PORT12_FN3),
	PINMUX_DATA(DU0_DG4_MARK,		PORT12_FN7),
	PINMUX_DATA(IRQ12_MARK,			PORT12_FN0),

	/* Port13 */
	PINMUX_DATA(LCDD13_MARK,		PORT13_FN1),
	PINMUX_DATA(FSICOLR_MARK,		PORT13_FN3),
	PINMUX_DATA(FSICILR_MARK,		PORT13_FN4),
	PINMUX_DATA(DU0_DG5_MARK,		PORT13_FN7),
	PINMUX_DATA(IRQ13_MARK,			PORT13_FN0),

	/* Port14 */
	PINMUX_DATA(LCDD14_MARK,		PORT14_FN1),
	PINMUX_DATA(FSICOBT_MARK,		PORT14_FN3),
	PINMUX_DATA(FSICIBT_MARK,		PORT14_FN4),
	PINMUX_DATA(DU0_DG6_MARK,		PORT14_FN7),
	PINMUX_DATA(IRQ14_MARK,			PORT14_FN0),

	/* Port15 */
	PINMUX_DATA(LCDD15_MARK,		PORT15_FN1),
	PINMUX_DATA(FSICOSLD_MARK,		PORT15_FN3),
	PINMUX_DATA(DU0_DG7_MARK,		PORT15_FN7),
	PINMUX_DATA(IRQ15_MARK,			PORT15_FN0),

	/* Port16 */
	PINMUX_DATA(LCDD16_MARK,		PORT16_FN1),
	PINMUX_DATA(TPU1TO1_MARK,		PORT16_FN4),
	PINMUX_DATA(DU0_DB0_MARK,		PORT16_FN7),

	/* Port17 */
	PINMUX_DATA(LCDD17_MARK,		PORT17_FN1),
	PINMUX_DATA(SF_IRQ_00_MARK,		PORT17_FN4),
	PINMUX_DATA(DU0_DB1_MARK,		PORT17_FN7),

	/* Port18 */
	PINMUX_DATA(LCDD18_MARK,		PORT18_FN1),
	PINMUX_DATA(SF_IRQ_01_MARK,		PORT18_FN4),
	PINMUX_DATA(DU0_DB2_MARK,		PORT18_FN7),

	/* Port19 */
	PINMUX_DATA(LCDD19_MARK,		PORT19_FN1),
	PINMUX_DATA(SCIFB3_RTS_19_MARK,		PORT19_FN3),
	PINMUX_DATA(DU0_DB3_MARK,		PORT19_FN7),

	/* Port20 */
	PINMUX_DATA(LCDD20_MARK,		PORT20_FN1),
	PINMUX_DATA(SCIFB3_CTS_20_MARK,		PORT20_FN3,	MSEL3CR_09_0),
	PINMUX_DATA(DU0_DB4_MARK,		PORT20_FN7),

	/* Port21 */
	PINMUX_DATA(LCDD21_MARK,		PORT21_FN1),
	PINMUX_DATA(SCIFB3_TXD_21_MARK,		PORT21_FN3,	MSEL3CR_09_0),
	PINMUX_DATA(DU0_DB5_MARK,		PORT21_FN7),

	/* Port22 */
	PINMUX_DATA(LCDD22_MARK,		PORT22_FN1),
	PINMUX_DATA(SCIFB3_RXD_22_MARK,		PORT22_FN3,	MSEL3CR_09_0),
	PINMUX_DATA(DU0_DB6_MARK,		PORT22_FN7),

	/* Port23 */
	PINMUX_DATA(LCDD23_MARK,		PORT23_FN1),
	PINMUX_DATA(SCIFB3_SCK_23_MARK,		PORT23_FN3),
	PINMUX_DATA(DU0_DB7_MARK,		PORT23_FN7),

	/* Port24 */
	PINMUX_DATA(LCDHSYN_MARK,			PORT24_FN1),
	PINMUX_DATA(LCDCS_MARK,				PORT24_FN2),
	PINMUX_DATA(SCIFB1_RTS_24_MARK,			PORT24_FN3),
	PINMUX_DATA(DU0_EXHSYNC_N_CSYNC_N_HSYNC_N_MARK,	PORT24_FN7),

	/* Port25 */
	PINMUX_DATA(LCDVSYN_MARK,			PORT25_FN1),
	PINMUX_DATA(SCIFB1_CTS_25_MARK, PORT25_FN3, MSEL3CR_11_0),
	PINMUX_DATA(DU0_EXVSYNC_N_VSYNC_N_CSYNC_N_MARK,	PORT25_FN7),

	/* Port26 */
	PINMUX_DATA(LCDDCK_MARK,		PORT26_FN1),
	PINMUX_DATA(LCDWR_MARK,			PORT26_FN2),
	PINMUX_DATA(SCIFB1_TXD_26_MARK,		PORT26_FN3,	MSEL3CR_11_0),
	PINMUX_DATA(DU0_DOTCLKIN_MARK,		PORT26_FN7),

	/* Port27 */
	PINMUX_DATA(LCDDISP_MARK,		PORT27_FN1),
	PINMUX_DATA(LCDRS_MARK,			PORT27_FN2),
	PINMUX_DATA(SCIFB1_RXD_27_MARK,		PORT27_FN3,	MSEL3CR_11_0),
	PINMUX_DATA(DU0_DOTCLKOUT_MARK,		PORT27_FN7),

	/* Port28 */
	PINMUX_DATA(LCDRD_N_MARK,		PORT28_FN1),
	PINMUX_DATA(SCIFB1_SCK_28_MARK,		PORT28_FN3),
	PINMUX_DATA(DU0_DOTCLKOUTB_MARK,	PORT28_FN7),

	/* Port29 */
	PINMUX_DATA(LCDLCLK_MARK,		PORT29_FN1),
	PINMUX_DATA(SF_IRQ_02_MARK,		PORT29_FN4),
	PINMUX_DATA(DU0_DISP_CSYNC_N_DE_MARK,	PORT29_FN7),

	/* Port30 */
	PINMUX_DATA(LCDDON_MARK,		PORT30_FN1),
	PINMUX_DATA(SF_IRQ_03_MARK,		PORT30_FN4),
	PINMUX_DATA(DU0_ODDF_N_CLAMP_MARK,	PORT30_FN7),

	/* Port32 */
	PINMUX_DATA(SCIFA0_RTS_MARK,		PORT32_FN1),
	PINMUX_DATA(SIM0_DET_MARK,		PORT32_FN5),
	PINMUX_DATA(CSCIF0_RTS_MARK,		PORT32_FN7),

	/* Port33 */
	PINMUX_DATA(SCIFA0_CTS_MARK,		PORT33_FN1),
	PINMUX_DATA(SIM1_DET_MARK,		PORT33_FN5),
	PINMUX_DATA(CSCIF0_CTS_MARK,		PORT33_FN7),

	/* Port34 */
	PINMUX_DATA(SCIFA0_SCK_MARK,		PORT34_FN1),
	PINMUX_DATA(SIM0_PWRON_MARK,		PORT34_FN5),
	PINMUX_DATA(CSCIF0_SCK_MARK,		PORT34_FN7),

	/* Port35 */
	PINMUX_DATA(SCIFA1_RTS_MARK,		PORT35_FN1),
	PINMUX_DATA(CSCIF1_RTS_MARK,		PORT35_FN7),

	/* Port36 */
	PINMUX_DATA(SCIFA1_CTS_MARK,		PORT36_FN1),
	PINMUX_DATA(CSCIF1_CTS_MARK,		PORT36_FN7),

	/* Port37 */
	PINMUX_DATA(SCIFA1_SCK_MARK,		PORT37_FN1),
	PINMUX_DATA(CSCIF1_SCK_MARK,		PORT37_FN7),

	/* Port38 */
	PINMUX_DATA(SCIFB0_RTS_MARK,		PORT38_FN1),
	PINMUX_DATA(TPU0TO1_MARK,		PORT38_FN3),
	PINMUX_DATA(SCIFB3_RTS_38_MARK,		PORT38_FN4),
	PINMUX_DATA(CHSCIF0_HRTS_MARK,		PORT38_FN7),

	/* Port39 */
	PINMUX_DATA(SCIFB0_CTS_MARK,		PORT39_FN1),
	PINMUX_DATA(TPU0TO2_MARK,		PORT39_FN3),
	PINMUX_DATA(SCIFB3_CTS_39_MARK,		PORT39_FN4,	MSEL3CR_09_1),
	PINMUX_DATA(CHSCIF0_HCTS_MARK,		PORT39_FN7),

	/* Port40 */
	PINMUX_DATA(SCIFB0_SCK_MARK,		PORT40_FN1),
	PINMUX_DATA(TPU0TO3_MARK,		PORT40_FN3),
	PINMUX_DATA(SCIFB3_SCK_40_MARK,		PORT40_FN4),
	PINMUX_DATA(CHSCIF0_HSCK_MARK,		PORT40_FN7),

	/* Port64 */
	PINMUX_DATA(PDM0_DATA_MARK,		PORT64_FN1),

	/* Port65 */
	PINMUX_DATA(PDM1_DATA_MARK,		PORT65_FN1),

	/* Port66 */
	PINMUX_DATA(HSI_RX_WAKE_MARK,		PORT66_FN1),
	PINMUX_DATA(SCIFB2_CTS_66_MARK,		PORT66_FN2,	MSEL3CR_10_0),
	PINMUX_DATA(MSIOF3_SYNC_MARK,		PORT66_FN3),
	PINMUX_DATA(GenIO4_MARK,		PORT66_FN5),
	PINMUX_DATA(IRQ40_MARK,			PORT66_FN0),

	/* Port67 */
	PINMUX_DATA(HSI_RX_READY_MARK,		PORT67_FN1),
	PINMUX_DATA(SCIFB1_TXD_67_MARK,		PORT67_FN2,	MSEL3CR_11_1),
	PINMUX_DATA(GIO_OUT3_67_MARK,		PORT67_FN5),
	PINMUX_DATA(CHSCIF1_HTX_MARK,		PORT67_FN7),

	/* Port68 */
	PINMUX_DATA(HSI_RX_FLAG_MARK,		PORT68_FN1),
	PINMUX_DATA(SCIFB2_TXD_68_MARK,		PORT68_FN2,	MSEL3CR_10_0),
	PINMUX_DATA(MSIOF3_TXD_MARK,		PORT68_FN3),
	PINMUX_DATA(GIO_OUT4_68_MARK,		PORT68_FN5),

	/* Port69 */
	PINMUX_DATA(HSI_RX_DATA_MARK,		PORT69_FN1),
	PINMUX_DATA(SCIFB2_RXD_69_MARK,		PORT69_FN2,	MSEL3CR_10_0),
	PINMUX_DATA(MSIOF3_RXD_MARK,		PORT69_FN3),
	PINMUX_DATA(GIO_OUT5_69_MARK,		PORT69_FN5),

	/* Port70 */
	PINMUX_DATA(HSI_TX_FLAG_MARK,		PORT70_FN1),
	PINMUX_DATA(SCIFB1_RTS_70_MARK,		PORT70_FN2),
	PINMUX_DATA(GIO_OUT1_70_MARK,		PORT70_FN5),
	PINMUX_DATA(HSIC_TSTCLK0_MARK,		PORT70_FN6),
	PINMUX_DATA(CHSCIF1_HRTS_MARK,		PORT70_FN7),

	/* Port71 */
	PINMUX_DATA(HSI_TX_DATA_MARK,		PORT71_FN1),
	PINMUX_DATA(SCIFB1_CTS_71_MARK,		PORT71_FN2,	MSEL3CR_11_1),
	PINMUX_DATA(GIO_OUT2_71_MARK,		PORT71_FN5),
	PINMUX_DATA(HSIC_TSTCLK1_MARK,		PORT71_FN6),
	PINMUX_DATA(CHSCIF1_HCTS_MARK,		PORT71_FN7),

	/* Port72 */
	PINMUX_DATA(HSI_TX_WAKE_MARK,		PORT72_FN1),
	PINMUX_DATA(SCIFB1_RXD_72_MARK,		PORT72_FN2,	MSEL3CR_11_1),
	PINMUX_DATA(GenIO8_MARK,		PORT72_FN5),
	PINMUX_DATA(CHSCIF1_HRX_MARK,		PORT72_FN7),

	/* Port73 */
	PINMUX_DATA(HSI_TX_READY_MARK,		PORT73_FN1),
	PINMUX_DATA(SCIFB2_RTS_73_MARK,		PORT73_FN2),
	PINMUX_DATA(MSIOF3_SCK_MARK,		PORT73_FN3),
	PINMUX_DATA(GIO_OUT0_73_MARK,		PORT73_FN5),

	/* Port74 - Port85 */
	PINMUX_DATA(IRDA_OUT_MARK,		PORT74_FN1),
	PINMUX_DATA(IRDA_IN_MARK,		PORT75_FN1),
	PINMUX_DATA(IRDA_FIRSEL_MARK,		PORT76_FN1),
	PINMUX_DATA(TPU0TO0_MARK,		PORT77_FN1),
	PINMUX_DATA(DIGRFEN_MARK,		PORT78_FN1),
	PINMUX_DATA(GPS_TIMESTAMP_MARK,		PORT79_FN1),
	PINMUX_DATA(TXP_MARK,			PORT80_FN1),
	PINMUX_DATA(TXP2_MARK,			PORT81_FN1),
	PINMUX_DATA(COEX_0_MARK,		PORT82_FN1),
	PINMUX_DATA(COEX_1_MARK,		PORT83_FN1),
	PINMUX_DATA(IRQ19_MARK,			PORT84_FN0),
	PINMUX_DATA(IRQ18_MARK,			PORT85_FN0),

	/* Port96 - Port101 */
	PINMUX_DATA(KEYIN0_MARK,		PORT96_FN1),
	PINMUX_DATA(KEYIN1_MARK,		PORT97_FN1),
	PINMUX_DATA(KEYIN2_MARK,		PORT98_FN1),
	PINMUX_DATA(KEYIN3_MARK,		PORT99_FN1),
	PINMUX_DATA(KEYIN4_MARK,		PORT100_FN1),
	PINMUX_DATA(KEYIN5_MARK,		PORT101_FN1),

	/* Port102 */
	PINMUX_DATA(KEYIN6_MARK,		PORT102_FN1),
	PINMUX_DATA(IRQ41_MARK,			PORT102_FN0),

	/* Port103 */
	PINMUX_DATA(KEYIN7_MARK,		PORT103_FN1),
	PINMUX_DATA(IRQ42_MARK,			PORT103_FN0),

	/* Port104 - Port108 */
	PINMUX_DATA(KEYOUT0_MARK,		PORT104_FN2),
	PINMUX_DATA(KEYOUT1_MARK,		PORT105_FN2),
	PINMUX_DATA(KEYOUT2_MARK,		PORT106_FN2),
	PINMUX_DATA(KEYOUT3_MARK,		PORT107_FN2),
	PINMUX_DATA(KEYOUT4_MARK,		PORT108_FN2),

	/* Port109 */
	PINMUX_DATA(KEYOUT5_MARK,		PORT109_FN2),
	PINMUX_DATA(IRQ43_MARK,			PORT109_FN0),

	/* Port110 */
	PINMUX_DATA(KEYOUT6_MARK,		PORT110_FN2),
	PINMUX_DATA(IRQ44_MARK,			PORT110_FN0),

	/* Port111 */
	PINMUX_DATA(KEYOUT7_MARK,		PORT111_FN2),
	PINMUX_DATA(RFANAEN_MARK,		PORT111_FN5),
	PINMUX_DATA(IRQ45_MARK,			PORT111_FN0),

	/* Port112 */
	PINMUX_DATA(KEYIN8_MARK,		PORT112_FN1),
	PINMUX_DATA(KEYOUT8_MARK,		PORT112_FN2),
	PINMUX_DATA(SF_IRQ_04_MARK,		PORT112_FN4),
	PINMUX_DATA(IRQ46_MARK,			PORT112_FN0),

	/* Port113 */
	PINMUX_DATA(KEYIN9_MARK,		PORT113_FN1),
	PINMUX_DATA(KEYOUT9_MARK,		PORT113_FN2),
	PINMUX_DATA(SF_IRQ_05_MARK,		PORT113_FN4),
	PINMUX_DATA(IRQ47_MARK,			PORT113_FN0),

	/* Port114 */
	PINMUX_DATA(KEYIN10_MARK,		PORT114_FN1),
	PINMUX_DATA(KEYOUT10_MARK,		PORT114_FN2),
	PINMUX_DATA(SF_IRQ_06_MARK,		PORT114_FN4),
	PINMUX_DATA(IRQ48_MARK,			PORT114_FN0),

	/* Port115 */
	PINMUX_DATA(KEYIN11_MARK,		PORT115_FN1),
	PINMUX_DATA(KEYOUT11_MARK,		PORT115_FN2),
	PINMUX_DATA(SF_IRQ_07_MARK,		PORT115_FN4),
	PINMUX_DATA(IRQ49_MARK,			PORT115_FN0),

	/* Port116 */
	PINMUX_DATA(SCIFA0_TXD_MARK,		PORT116_FN1),
	PINMUX_DATA(CSCIF0_TX_MARK,		PORT116_FN7),

	/* Port117 */
	PINMUX_DATA(SCIFA0_RXD_MARK,		PORT117_FN1),
	PINMUX_DATA(CSCIF0_RX_MARK,		PORT117_FN7),

	/* Port118 */
	PINMUX_DATA(SCIFA1_TXD_MARK,		PORT118_FN1),
	PINMUX_DATA(CSCIF1_TX_MARK,		PORT118_FN7),

	/* Port119 */
	PINMUX_DATA(SCIFA1_RXD_MARK,		PORT119_FN1),
	PINMUX_DATA(CSCIF1_RX_MARK,		PORT119_FN7),

	/* Port120 */
	PINMUX_DATA(SF_PORT_1_120_MARK,		PORT120_FN3),
	PINMUX_DATA(SCIFB3_RXD_120_MARK,	PORT120_FN4,	MSEL3CR_09_1),
	PINMUX_DATA(DU0_CDE_MARK,		PORT120_FN7),

	/* Port121 */
	PINMUX_DATA(SF_PORT_0_121_MARK,		PORT121_FN3),
	PINMUX_DATA(SCIFB3_TXD_121_MARK,	PORT121_FN4,	MSEL3CR_09_1),

	/* Port122 */
	PINMUX_DATA(SCIFB0_TXD_MARK,		PORT122_FN1),
	PINMUX_DATA(CHSCIF0_HTX_MARK,		PORT122_FN7),

	/* Port123 */
	PINMUX_DATA(SCIFB0_RXD_MARK,		PORT123_FN1),
	PINMUX_DATA(CHSCIF0_HRX_MARK,		PORT123_FN7),

	/* Port124 */
	PINMUX_DATA(ISP_STROBE_124_MARK,	PORT124_FN3),

	/* Port125 */
	PINMUX_DATA(STP_ISD_0_MARK,		PORT125_FN1),
	PINMUX_DATA(PDM4_CLK_125_MARK,		PORT125_FN2),
	PINMUX_DATA(MSIOF2_TXD_MARK,		PORT125_FN3),
	PINMUX_DATA(SIM0_VOLTSEL0_MARK,		PORT125_FN5),

	/* Port126 */
	PINMUX_DATA(TS_SDEN_MARK,		PORT126_FN1),
	PINMUX_DATA(MSIOF7_SYNC_MARK,		PORT126_FN2),
	PINMUX_DATA(STP_ISEN_1_MARK,		PORT126_FN3),

	/* Port128 */
	PINMUX_DATA(STP_ISEN_0_MARK,		PORT128_FN1),
	PINMUX_DATA(PDM1_OUTDATA_128_MARK,	PORT128_FN2),
	PINMUX_DATA(MSIOF2_SYNC_MARK,		PORT128_FN3),
	PINMUX_DATA(SIM1_VOLTSEL1_MARK,		PORT128_FN5),

	/* Port129 */
	PINMUX_DATA(TS_SPSYNC_MARK,		PORT129_FN1),
	PINMUX_DATA(MSIOF7_RXD_MARK,		PORT129_FN2),
	PINMUX_DATA(STP_ISSYNC_1_MARK,		PORT129_FN3),

	/* Port130 */
	PINMUX_DATA(STP_ISSYNC_0_MARK,		PORT130_FN1),
	PINMUX_DATA(PDM4_DATA_130_MARK,		PORT130_FN2,	MSEL3CR_12_1),
	PINMUX_DATA(MSIOF2_RXD_MARK,		PORT130_FN3),
	PINMUX_DATA(SIM0_VOLTSEL1_MARK,		PORT130_FN5),

	/* Port131 */
	PINMUX_DATA(STP_OPWM_0_MARK,		PORT131_FN1),
	PINMUX_DATA(SIM1_PWRON_MARK,		PORT131_FN5),

	/* Port132 */
	PINMUX_DATA(TS_SCK_MARK,		PORT132_FN1),
	PINMUX_DATA(MSIOF7_SCK_MARK,		PORT132_FN2),
	PINMUX_DATA(STP_ISCLK_1_MARK,		PORT132_FN3),

	/* Port133 */
	PINMUX_DATA(STP_ISCLK_0_MARK,		PORT133_FN1),
	PINMUX_DATA(PDM1_OUTCLK_133_MARK,	PORT133_FN2),
	PINMUX_DATA(MSIOF2_SCK_MARK,		PORT133_FN3),
	PINMUX_DATA(SIM1_VOLTSEL0_MARK,		PORT133_FN5),

	/* Port134 */
	PINMUX_DATA(TS_SDAT_MARK,		PORT134_FN1),
	PINMUX_DATA(MSIOF7_TXD_MARK,		PORT134_FN2),
	PINMUX_DATA(STP_ISD_1_MARK,		PORT134_FN3),

	/* Port160 - Port178 */
	PINMUX_DATA(IRQ20_MARK,			PORT160_FN0),
	PINMUX_DATA(IRQ21_MARK,			PORT161_FN0),
	PINMUX_DATA(IRQ22_MARK,			PORT162_FN0),
	PINMUX_DATA(IRQ23_MARK,			PORT163_FN0),
	PINMUX_DATA(MMCD0_0_MARK,		PORT164_FN1),
	PINMUX_DATA(MMCD0_1_MARK,		PORT165_FN1),
	PINMUX_DATA(MMCD0_2_MARK,		PORT166_FN1),
	PINMUX_DATA(MMCD0_3_MARK,		PORT167_FN1),
	PINMUX_DATA(MMCD0_4_MARK,		PORT168_FN1),
	PINMUX_DATA(MMCD0_5_MARK,		PORT169_FN1),
	PINMUX_DATA(MMCD0_6_MARK,		PORT170_FN1),
	PINMUX_DATA(MMCD0_7_MARK,		PORT171_FN1),
	PINMUX_DATA(MMCCMD0_MARK,		PORT172_FN1),
	PINMUX_DATA(MMCCLK0_MARK,		PORT173_FN1),
	PINMUX_DATA(MMCRST_MARK,		PORT174_FN1),
	PINMUX_DATA(IRQ24_MARK,			PORT175_FN0),
	PINMUX_DATA(IRQ25_MARK,			PORT176_FN0),
	PINMUX_DATA(IRQ26_MARK,			PORT177_FN0),
	PINMUX_DATA(IRQ27_MARK,			PORT178_FN0),

	/* Port192 - Port200 FN1 */
	PINMUX_DATA(A10_MARK,		PORT192_FN1),
	PINMUX_DATA(A9_MARK,		PORT193_FN1),
	PINMUX_DATA(A8_MARK,		PORT194_FN1),
	PINMUX_DATA(A7_MARK,		PORT195_FN1),
	PINMUX_DATA(A6_MARK,		PORT196_FN1),
	PINMUX_DATA(A5_MARK,		PORT197_FN1),
	PINMUX_DATA(A4_MARK,		PORT198_FN1),
	PINMUX_DATA(A3_MARK,		PORT199_FN1),
	PINMUX_DATA(A2_MARK,		PORT200_FN1),

	/* Port192 - Port200 FN2 */
	PINMUX_DATA(MMCD1_7_MARK,		PORT192_FN2),
	PINMUX_DATA(MMCD1_6_MARK,		PORT193_FN2),
	PINMUX_DATA(MMCD1_5_MARK,		PORT194_FN2),
	PINMUX_DATA(MMCD1_4_MARK,		PORT195_FN2),
	PINMUX_DATA(MMCD1_3_MARK,		PORT196_FN2),
	PINMUX_DATA(MMCD1_2_MARK,		PORT197_FN2),
	PINMUX_DATA(MMCD1_1_MARK,		PORT198_FN2),
	PINMUX_DATA(MMCD1_0_MARK,		PORT199_FN2),
	PINMUX_DATA(MMCCMD1_MARK,		PORT200_FN2),

	/* Port192 - Port200 IRQ */
	PINMUX_DATA(IRQ31_MARK,			PORT192_FN0),
	PINMUX_DATA(IRQ32_MARK,			PORT193_FN0),
	PINMUX_DATA(IRQ33_MARK,			PORT194_FN0),
	PINMUX_DATA(IRQ34_MARK,			PORT195_FN0),
	PINMUX_DATA(IRQ35_MARK,			PORT196_FN0),
	PINMUX_DATA(IRQ36_MARK,			PORT197_FN0),
	PINMUX_DATA(IRQ37_MARK,			PORT198_FN0),
	PINMUX_DATA(IRQ38_MARK,			PORT199_FN0),
	PINMUX_DATA(IRQ39_MARK,			PORT200_FN0),

	/* Port201 */
	PINMUX_DATA(A1_MARK,		PORT201_FN1),

	/* Port202 */
	PINMUX_DATA(A0_MARK,		PORT202_FN1),
	PINMUX_DATA(BS_MARK,		PORT202_FN2),

	/* Port203 */
	PINMUX_DATA(CKO_MARK,		PORT203_FN1),
	PINMUX_DATA(MMCCLK1_MARK,	PORT203_FN2),

	/* Port204 */
	PINMUX_DATA(CS0_N_MARK,		PORT204_FN1),
	PINMUX_DATA(SIM0_GPO1_MARK,	PORT204_FN5),

	/* Port205 */
	PINMUX_DATA(CS2_N_MARK,		PORT205_FN1),
	PINMUX_DATA(SIM0_GPO2_MARK,	PORT205_FN5),

	/* Port206 */
	PINMUX_DATA(CS4_N_MARK,		PORT206_FN1),
	PINMUX_DATA(VIO_VD_MARK,	PORT206_FN2),
	PINMUX_DATA(SIM1_GPO0_MARK,	PORT206_FN5),

	/* Port207 - Port212 FN1 */
	PINMUX_DATA(D15_MARK,		PORT207_FN1),
	PINMUX_DATA(D14_MARK,		PORT208_FN1),
	PINMUX_DATA(D13_MARK,		PORT209_FN1),
	PINMUX_DATA(D12_MARK,		PORT210_FN1),
	PINMUX_DATA(D11_MARK,		PORT211_FN1),
	PINMUX_DATA(D10_MARK,		PORT212_FN1),

	/* Port207 - Port212 FN5 */
	PINMUX_DATA(GIO_OUT15_MARK,			PORT207_FN5),
	PINMUX_DATA(GIO_OUT14_MARK,			PORT208_FN5),
	PINMUX_DATA(GIO_OUT13_MARK,			PORT209_FN5),
	PINMUX_DATA(GIO_OUT12_MARK,			PORT210_FN5),
	PINMUX_DATA(WGM_TXP2_MARK,			PORT211_FN5),
	PINMUX_DATA(WGM_GPS_TIMEM_ASK_RFCLK_MARK,	PORT212_FN5),

	/* Port213 - Port222 FN1 */
	PINMUX_DATA(D9_MARK,		PORT213_FN1),
	PINMUX_DATA(D8_MARK,		PORT214_FN1),
	PINMUX_DATA(D7_MARK,		PORT215_FN1),
	PINMUX_DATA(D6_MARK,		PORT216_FN1),
	PINMUX_DATA(D5_MARK,		PORT217_FN1),
	PINMUX_DATA(D4_MARK,		PORT218_FN1),
	PINMUX_DATA(D3_MARK,		PORT219_FN1),
	PINMUX_DATA(D2_MARK,		PORT220_FN1),
	PINMUX_DATA(D1_MARK,		PORT221_FN1),
	PINMUX_DATA(D0_MARK,		PORT222_FN1),

	/* Port213 - Port222 FN2 */
	PINMUX_DATA(VIO_D9_MARK,	PORT213_FN2),
	PINMUX_DATA(VIO_D8_MARK,	PORT214_FN2),
	PINMUX_DATA(VIO_D7_MARK,	PORT215_FN2),
	PINMUX_DATA(VIO_D6_MARK,	PORT216_FN2),
	PINMUX_DATA(VIO_D5_MARK,	PORT217_FN2),
	PINMUX_DATA(VIO_D4_MARK,	PORT218_FN2),
	PINMUX_DATA(VIO_D3_MARK,	PORT219_FN2),
	PINMUX_DATA(VIO_D2_MARK,	PORT220_FN2),
	PINMUX_DATA(VIO_D1_MARK,	PORT221_FN2),
	PINMUX_DATA(VIO_D0_MARK,	PORT222_FN2),

	/* Port213 - Port222 FN5 */
	PINMUX_DATA(GIO_OUT9_MARK,	PORT213_FN5),
	PINMUX_DATA(GIO_OUT8_MARK,	PORT214_FN5),
	PINMUX_DATA(GIO_OUT7_MARK,	PORT215_FN5),
	PINMUX_DATA(GIO_OUT6_MARK,	PORT216_FN5),
	PINMUX_DATA(GIO_OUT5_217_MARK,	PORT217_FN5),
	PINMUX_DATA(GIO_OUT4_218_MARK,	PORT218_FN5),
	PINMUX_DATA(GIO_OUT3_219_MARK,	PORT219_FN5),
	PINMUX_DATA(GIO_OUT2_220_MARK,	PORT220_FN5),
	PINMUX_DATA(GIO_OUT1_221_MARK,	PORT221_FN5),
	PINMUX_DATA(GIO_OUT0_222_MARK,	PORT222_FN5),

	/* Port224 */
	PINMUX_DATA(RDWR_224_MARK,	PORT224_FN1),
	PINMUX_DATA(VIO_HD_MARK,	PORT224_FN2),
	PINMUX_DATA(SIM1_GPO2_MARK,	PORT224_FN5),

	/* Port225 */
	PINMUX_DATA(RD_N_MARK,		PORT225_FN1),

	/* Port226 */
	PINMUX_DATA(WAIT_N_MARK,	PORT226_FN1),
	PINMUX_DATA(VIO_CLK_MARK,	PORT226_FN2),
	PINMUX_DATA(SIM1_GPO1_MARK,	PORT226_FN5),

	/* Port227 */
	PINMUX_DATA(WE0_N_MARK,		PORT227_FN1),
	PINMUX_DATA(RDWR_227_MARK,	PORT227_FN2),

	/* Port228 */
	PINMUX_DATA(WE1_N_MARK,		PORT228_FN1),
	PINMUX_DATA(SIM0_GPO0_MARK,	PORT228_FN5),

	/* Port229 */
	PINMUX_DATA(PWMO_MARK,		PORT229_FN1),
	PINMUX_DATA(VIO_CKO1_229_MARK,	PORT229_FN2),

	/* Port230 */
	PINMUX_DATA(SLIM_CLK_MARK,	PORT230_FN1),
	PINMUX_DATA(VIO_CKO4_230_MARK,	PORT230_FN2),

	/* Port231 */
	PINMUX_DATA(SLIM_DATA_MARK,	PORT231_FN1),
	PINMUX_DATA(VIO_CKO5_231_MARK,	PORT231_FN2),

	/* Port232 */
	PINMUX_DATA(VIO_CKO2_232_MARK,	PORT232_FN2),
	PINMUX_DATA(SF_PORT_0_232_MARK,	PORT232_FN4),

	/* Port233 */
	PINMUX_DATA(VIO_CKO3_233_MARK,	PORT233_FN2),
	PINMUX_DATA(SF_PORT_1_233_MARK,	PORT233_FN4),

	/* Port234 */
	PINMUX_DATA(FSIACK_MARK,	PORT234_FN1),
	PINMUX_DATA(PDM3_CLK_234_MARK,	PORT234_FN2),
	PINMUX_DATA(ISP_IRIS1_234_MARK,	PORT234_FN3),

	/* Port235 */
	PINMUX_DATA(FSIAISLD_MARK,	PORT235_FN1),
	PINMUX_DATA(PDM3_DATA_235_MARK,	PORT235_FN2,	MSEL3CR_12_1),

	/* Port236 */
	PINMUX_DATA(FSIAOMC_MARK,		PORT236_FN1),
	PINMUX_DATA(PDM0_OUTCLK_236_MARK,	PORT236_FN2),
	PINMUX_DATA(ISP_IRIS0_236_MARK,		PORT236_FN3),

	/* Port237 */
	PINMUX_DATA(FSIAOLR_MARK,	PORT237_FN1),
	PINMUX_DATA(FSIAILR_MARK,	PORT237_FN2),

	/* Port238 */
	PINMUX_DATA(FSIAOBT_MARK,	PORT238_FN1),
	PINMUX_DATA(FSIAIBT_MARK,	PORT238_FN2),

	/* Port239 */
	PINMUX_DATA(FSIAOSLD_MARK,		PORT239_FN1),
	PINMUX_DATA(PDM0_OUTDATA_239_MARK,	PORT239_FN2),

	/* Port240 */
	PINMUX_DATA(FSIBISLD_MARK,	PORT240_FN1),

	/* Port241 */
	PINMUX_DATA(FSIBOLR_MARK,	PORT241_FN1),
	PINMUX_DATA(FSIBILR_MARK,	PORT241_FN2),

	/* Port242 */
	PINMUX_DATA(FSIBOMC_MARK,		PORT242_FN1),
	PINMUX_DATA(ISP_SHUTTER1_242_MARK,	PORT242_FN3),

	/* Port243 */
	PINMUX_DATA(FSIBOBT_MARK,	PORT243_FN1),
	PINMUX_DATA(FSIBIBT_MARK,	PORT243_FN2),

	/* Port244 */
	PINMUX_DATA(FSIBOSLD_MARK,	PORT244_FN1),
	PINMUX_DATA(FSIASPDIF_MARK,	PORT244_FN2),

	/* Port245 */
	PINMUX_DATA(FSIBCK_MARK,		PORT245_FN1),
	PINMUX_DATA(ISP_SHUTTER0_245_MARK,	PORT245_FN3),

	/* Port246 - Port250 FN1 */
	PINMUX_DATA(ISP_IRIS1_246_MARK,		PORT246_FN1),
	PINMUX_DATA(ISP_IRIS0_247_MARK,		PORT247_FN1),
	PINMUX_DATA(ISP_SHUTTER1_248_MARK,	PORT248_FN1),
	PINMUX_DATA(ISP_SHUTTER0_249_MARK,	PORT249_FN1),
	PINMUX_DATA(ISP_STROBE_250_MARK,	PORT250_FN1),

	/* Port256 - Port258 */
	PINMUX_DATA(MSIOF0_SYNC_MARK,		PORT256_FN1),
	PINMUX_DATA(MSIOF0_RXD_MARK,		PORT257_FN1),
	PINMUX_DATA(MSIOF0_SCK_MARK,		PORT258_FN1),

	/* Port259 */
	PINMUX_DATA(MSIOF0_SS2_MARK,		PORT259_FN1),
	PINMUX_DATA(VIO_CKO3_259_MARK,		PORT259_FN3),

	/* Port260 */
	PINMUX_DATA(MSIOF0_TXD_MARK,		PORT260_FN1),

	/* Port261 */
	PINMUX_DATA(SCIFB1_SCK_261_MARK,	PORT261_FN2),
	PINMUX_DATA(CHSCIF1_HSCK_MARK,		PORT261_FN7),

	/* Port262 */
	PINMUX_DATA(SCIFB2_SCK_262_MARK,	PORT262_FN2),

	/* Port263 - Port266 FN1 */
	PINMUX_DATA(MSIOF1_SS2_MARK,		PORT263_FN1),
	PINMUX_DATA(MSIOF1_TXD_MARK,		PORT264_FN1),
	PINMUX_DATA(MSIOF1_RXD_MARK,		PORT265_FN1),
	PINMUX_DATA(MSIOF1_SS1_MARK,		PORT266_FN1),

	/* Port263 - Port266 FN4 */
	PINMUX_DATA(MSIOF5_SS2_MARK,		PORT263_FN4),
	PINMUX_DATA(MSIOF5_TXD_MARK,		PORT264_FN4),
	PINMUX_DATA(MSIOF5_RXD_MARK,		PORT265_FN4),
	PINMUX_DATA(MSIOF5_SS1_MARK,		PORT266_FN4),

	/* Port267 */
	PINMUX_DATA(MSIOF0_SS1_MARK,		PORT267_FN1),

	/* Port268 */
	PINMUX_DATA(MSIOF1_SCK_MARK,		PORT268_FN1),
	PINMUX_DATA(MSIOF5_SCK_MARK,		PORT268_FN4),

	/* Port269 */
	PINMUX_DATA(MSIOF1_SYNC_MARK,		PORT269_FN1),
	PINMUX_DATA(MSIOF5_SYNC_MARK,		PORT269_FN4),

	/* Port270 - Port273 FN1 */
	PINMUX_DATA(MSIOF2_SS1_MARK,		PORT270_FN1),
	PINMUX_DATA(MSIOF2_SS2_MARK,		PORT271_FN1),
	PINMUX_DATA(MSIOF3_SS2_MARK,		PORT272_FN1),
	PINMUX_DATA(MSIOF3_SS1_MARK,		PORT273_FN1),

	/* Port270 - Port273 FN3 */
	PINMUX_DATA(VIO_CKO5_270_MARK,		PORT270_FN3),
	PINMUX_DATA(VIO_CKO2_271_MARK,		PORT271_FN3),
	PINMUX_DATA(VIO_CKO1_272_MARK,		PORT272_FN3),
	PINMUX_DATA(VIO_CKO4_273_MARK,		PORT273_FN3),

	/* Port274 */
	PINMUX_DATA(MSIOF4_SS2_MARK,		PORT274_FN1),
	PINMUX_DATA(TPU1TO0_MARK,		PORT274_FN4),

	/* Port275 - Port280 */
	PINMUX_DATA(IC_DP_MARK,			PORT275_FN1),
	PINMUX_DATA(SIM0_RST_MARK,		PORT276_FN1),
	PINMUX_DATA(IC_DM_MARK,			PORT277_FN1),
	PINMUX_DATA(SIM0_BSICOMP_MARK,		PORT278_FN1),
	PINMUX_DATA(SIM0_CLK_MARK,		PORT279_FN1),
	PINMUX_DATA(SIM0_IO_MARK,		PORT280_FN1),

	/* Port281 */
	PINMUX_DATA(SIM1_IO_MARK,		PORT281_FN1),
	PINMUX_DATA(PDM2_DATA_281_MARK,		PORT281_FN2,	MSEL3CR_12_1),

	/* Port282 */
	PINMUX_DATA(SIM1_CLK_MARK,		PORT282_FN1),
	PINMUX_DATA(PDM2_CLK_282_MARK,		PORT282_FN2),

	/* Port283 */
	PINMUX_DATA(SIM1_RST_MARK,		PORT283_FN1),

	/* Port289 */
	PINMUX_DATA(SDHID1_0_MARK,		PORT289_FN1),
	PINMUX_DATA(STMDATA0_2_MARK,		PORT289_FN3),

	/* Port290 */
	PINMUX_DATA(SDHID1_1_MARK,		PORT290_FN1),
	PINMUX_DATA(STMDATA1_2_MARK,		PORT290_FN3),
	PINMUX_DATA(IRQ51_MARK,			PORT290_FN0),

	/* Port291 - Port294 FN1 */
	PINMUX_DATA(SDHID1_2_MARK,		PORT291_FN1),
	PINMUX_DATA(SDHID1_3_MARK,		PORT292_FN1),
	PINMUX_DATA(SDHICLK1_MARK,		PORT293_FN1),
	PINMUX_DATA(SDHICMD1_MARK,		PORT294_FN1),

	/* Port291 - Port294 FN3 */
	PINMUX_DATA(STMDATA2_2_MARK,		PORT291_FN3),
	PINMUX_DATA(STMDATA3_2_MARK,		PORT292_FN3),
	PINMUX_DATA(STMCLK_2_MARK,		PORT293_FN3),
	PINMUX_DATA(STMSIDI_2_MARK,		PORT294_FN3),

	/* Port295 */
	PINMUX_DATA(SDHID2_0_MARK,		PORT295_FN1),
	PINMUX_DATA(MSIOF4_TXD_MARK,		PORT295_FN2),
	PINMUX_DATA(SCIFB2_TXD_295_MARK,	PORT295_FN3,	MSEL3CR_10_1),
	PINMUX_DATA(MSIOF6_TXD_MARK,		PORT295_FN4),

	/* Port296 */
	PINMUX_DATA(SDHID2_1_MARK,		PORT296_FN1),
	PINMUX_DATA(MSIOF6_SS2_MARK,		PORT296_FN4),
	PINMUX_DATA(IRQ52_MARK,			PORT296_FN0),

	/* Port297 - Port300 FN1 */
	PINMUX_DATA(SDHID2_2_MARK,		PORT297_FN1),
	PINMUX_DATA(SDHID2_3_MARK,		PORT298_FN1),
	PINMUX_DATA(SDHICLK2_MARK,		PORT299_FN1),
	PINMUX_DATA(SDHICMD2_MARK,		PORT300_FN1),

	/* Port297 - Port300 FN2 */
	PINMUX_DATA(MSIOF4_RXD_MARK,		PORT297_FN2),
	PINMUX_DATA(MSIOF4_SYNC_MARK,		PORT298_FN2),
	PINMUX_DATA(MSIOF4_SCK_MARK,		PORT299_FN2),
	PINMUX_DATA(MSIOF4_SS1_MARK,		PORT300_FN2),

	/* Port297 - Port300 FN3 */
	PINMUX_DATA(SCIFB2_RXD_297_MARK,	PORT297_FN3,	MSEL3CR_10_1),
	PINMUX_DATA(SCIFB2_CTS_298_MARK,	PORT298_FN3,	MSEL3CR_10_1),
	PINMUX_DATA(SCIFB2_SCK_299_MARK,	PORT299_FN3),
	PINMUX_DATA(SCIFB2_RTS_300_MARK,	PORT300_FN3),

	/* Port297 - Port300 FN4 */
	PINMUX_DATA(MSIOF6_RXD_MARK,		PORT297_FN4),
	PINMUX_DATA(MSIOF6_SYNC_MARK,		PORT298_FN4),
	PINMUX_DATA(MSIOF6_SCK_MARK,		PORT299_FN4),
	PINMUX_DATA(MSIOF6_SS1_MARK,		PORT300_FN4),

	/* Port301 */
	PINMUX_DATA(SDHICD0_MARK,		PORT301_FN1),
	PINMUX_DATA(IRQ50_MARK,			PORT301_FN0),

	/* Port302 - Port306 FN1 */
	PINMUX_DATA(SDHID0_0_MARK,		PORT302_FN1),
	PINMUX_DATA(SDHID0_1_MARK,		PORT303_FN1),
	PINMUX_DATA(SDHID0_2_MARK,		PORT304_FN1),
	PINMUX_DATA(SDHID0_3_MARK,		PORT305_FN1),
	PINMUX_DATA(SDHICMD0_MARK,		PORT306_FN1),

	/* Port302 - Port306 FN3 */
	PINMUX_DATA(STMDATA0_1_MARK,		PORT302_FN3),
	PINMUX_DATA(STMDATA1_1_MARK,		PORT303_FN3),
	PINMUX_DATA(STMDATA2_1_MARK,		PORT304_FN3),
	PINMUX_DATA(STMDATA3_1_MARK,		PORT305_FN3),
	PINMUX_DATA(STMSIDI_1_MARK,		PORT306_FN3),

	/* Port307 */
	PINMUX_DATA(SDHIWP0_MARK,		PORT307_FN1),

	/* Port308 */
	PINMUX_DATA(SDHICLK0_MARK,		PORT308_FN1),
	PINMUX_DATA(STMCLK_1_MARK,		PORT308_FN3),

	/* Port320 - Port329 */
	PINMUX_DATA(IRQ16_MARK,			PORT320_FN0),
	PINMUX_DATA(IRQ17_MARK,			PORT321_FN0),
	PINMUX_DATA(IRQ28_MARK,			PORT322_FN0),
	PINMUX_DATA(IRQ29_MARK,			PORT323_FN0),
	PINMUX_DATA(IRQ30_MARK,			PORT324_FN0),
	PINMUX_DATA(IRQ53_MARK,			PORT325_FN0),
	PINMUX_DATA(IRQ54_MARK,			PORT326_FN0),
	PINMUX_DATA(IRQ55_MARK,			PORT327_FN0),
	PINMUX_DATA(IRQ56_MARK,			PORT328_FN0),
	PINMUX_DATA(IRQ57_MARK,			PORT329_FN0),
};

#define __O	(SH_PFC_PIN_CFG_OUTPUT)
#define __IO	(SH_PFC_PIN_CFG_INPUT | SH_PFC_PIN_CFG_OUTPUT)
#define __PUD	(SH_PFC_PIN_CFG_PULL_DOWN | SH_PFC_PIN_CFG_PULL_UP)

#define R8A73A4_PIN_IO_PU_PD(pin)       SH_PFC_PIN_CFG(pin, __IO | __PUD)
#define R8A73A4_PIN_O(pin)              SH_PFC_PIN_CFG(pin, __O)

static const struct sh_pfc_pin pinmux_pins[] = {
	R8A73A4_PIN_IO_PU_PD(0), R8A73A4_PIN_IO_PU_PD(1),
	R8A73A4_PIN_IO_PU_PD(2), R8A73A4_PIN_IO_PU_PD(3),
	R8A73A4_PIN_IO_PU_PD(4), R8A73A4_PIN_IO_PU_PD(5),
	R8A73A4_PIN_IO_PU_PD(6), R8A73A4_PIN_IO_PU_PD(7),
	R8A73A4_PIN_IO_PU_PD(8), R8A73A4_PIN_IO_PU_PD(9),
	R8A73A4_PIN_IO_PU_PD(10), R8A73A4_PIN_IO_PU_PD(11),
	R8A73A4_PIN_IO_PU_PD(12), R8A73A4_PIN_IO_PU_PD(13),
	R8A73A4_PIN_IO_PU_PD(14), R8A73A4_PIN_IO_PU_PD(15),
	R8A73A4_PIN_IO_PU_PD(16), R8A73A4_PIN_IO_PU_PD(17),
	R8A73A4_PIN_IO_PU_PD(18), R8A73A4_PIN_IO_PU_PD(19),
	R8A73A4_PIN_IO_PU_PD(20), R8A73A4_PIN_IO_PU_PD(21),
	R8A73A4_PIN_IO_PU_PD(22), R8A73A4_PIN_IO_PU_PD(23),
	R8A73A4_PIN_IO_PU_PD(24), R8A73A4_PIN_IO_PU_PD(25),
	R8A73A4_PIN_IO_PU_PD(26), R8A73A4_PIN_IO_PU_PD(27),
	R8A73A4_PIN_IO_PU_PD(28), R8A73A4_PIN_IO_PU_PD(29),
	R8A73A4_PIN_IO_PU_PD(30),
	R8A73A4_PIN_IO_PU_PD(32), R8A73A4_PIN_IO_PU_PD(33),
	R8A73A4_PIN_IO_PU_PD(34), R8A73A4_PIN_IO_PU_PD(35),
	R8A73A4_PIN_IO_PU_PD(36), R8A73A4_PIN_IO_PU_PD(37),
	R8A73A4_PIN_IO_PU_PD(38), R8A73A4_PIN_IO_PU_PD(39),
	R8A73A4_PIN_IO_PU_PD(40),
	R8A73A4_PIN_IO_PU_PD(64), R8A73A4_PIN_IO_PU_PD(65),
	R8A73A4_PIN_IO_PU_PD(66), R8A73A4_PIN_IO_PU_PD(67),
	R8A73A4_PIN_IO_PU_PD(68), R8A73A4_PIN_IO_PU_PD(69),
	R8A73A4_PIN_IO_PU_PD(70), R8A73A4_PIN_IO_PU_PD(71),
	R8A73A4_PIN_IO_PU_PD(72), R8A73A4_PIN_IO_PU_PD(73),
	R8A73A4_PIN_O(74), R8A73A4_PIN_IO_PU_PD(75),
	R8A73A4_PIN_IO_PU_PD(76), R8A73A4_PIN_IO_PU_PD(77),
	R8A73A4_PIN_IO_PU_PD(78), R8A73A4_PIN_IO_PU_PD(79),
	R8A73A4_PIN_IO_PU_PD(80), R8A73A4_PIN_IO_PU_PD(81),
	R8A73A4_PIN_IO_PU_PD(82), R8A73A4_PIN_IO_PU_PD(83),
	R8A73A4_PIN_IO_PU_PD(84), R8A73A4_PIN_IO_PU_PD(85),
	R8A73A4_PIN_IO_PU_PD(96), R8A73A4_PIN_IO_PU_PD(97),
	R8A73A4_PIN_IO_PU_PD(98), R8A73A4_PIN_IO_PU_PD(99),
	R8A73A4_PIN_IO_PU_PD(100), R8A73A4_PIN_IO_PU_PD(101),
	R8A73A4_PIN_IO_PU_PD(102), R8A73A4_PIN_IO_PU_PD(103),
	R8A73A4_PIN_IO_PU_PD(104), R8A73A4_PIN_IO_PU_PD(105),
	R8A73A4_PIN_IO_PU_PD(106), R8A73A4_PIN_IO_PU_PD(107),
	R8A73A4_PIN_IO_PU_PD(108), R8A73A4_PIN_IO_PU_PD(109),
	R8A73A4_PIN_IO_PU_PD(110), R8A73A4_PIN_IO_PU_PD(111),
	R8A73A4_PIN_IO_PU_PD(112), R8A73A4_PIN_IO_PU_PD(113),
	R8A73A4_PIN_IO_PU_PD(114), R8A73A4_PIN_IO_PU_PD(115),
	R8A73A4_PIN_IO_PU_PD(116), R8A73A4_PIN_IO_PU_PD(117),
	R8A73A4_PIN_IO_PU_PD(118), R8A73A4_PIN_IO_PU_PD(119),
	R8A73A4_PIN_IO_PU_PD(120), R8A73A4_PIN_IO_PU_PD(121),
	R8A73A4_PIN_IO_PU_PD(122), R8A73A4_PIN_IO_PU_PD(123),
	R8A73A4_PIN_IO_PU_PD(124), R8A73A4_PIN_IO_PU_PD(125),
	R8A73A4_PIN_IO_PU_PD(126),
	R8A73A4_PIN_IO_PU_PD(128), R8A73A4_PIN_IO_PU_PD(129),
	R8A73A4_PIN_IO_PU_PD(130), R8A73A4_PIN_IO_PU_PD(131),
	R8A73A4_PIN_IO_PU_PD(132), R8A73A4_PIN_IO_PU_PD(133),
	R8A73A4_PIN_IO_PU_PD(134),
	R8A73A4_PIN_IO_PU_PD(160), R8A73A4_PIN_IO_PU_PD(161),
	R8A73A4_PIN_IO_PU_PD(162), R8A73A4_PIN_IO_PU_PD(163),
	R8A73A4_PIN_IO_PU_PD(164), R8A73A4_PIN_IO_PU_PD(165),
	R8A73A4_PIN_IO_PU_PD(166), R8A73A4_PIN_IO_PU_PD(167),
	R8A73A4_PIN_IO_PU_PD(168), R8A73A4_PIN_IO_PU_PD(169),
	R8A73A4_PIN_IO_PU_PD(170), R8A73A4_PIN_IO_PU_PD(171),
	R8A73A4_PIN_IO_PU_PD(172), R8A73A4_PIN_IO_PU_PD(173),
	R8A73A4_PIN_IO_PU_PD(174), R8A73A4_PIN_IO_PU_PD(175),
	R8A73A4_PIN_IO_PU_PD(176), R8A73A4_PIN_IO_PU_PD(177),
	R8A73A4_PIN_IO_PU_PD(178),
	R8A73A4_PIN_IO_PU_PD(192), R8A73A4_PIN_IO_PU_PD(193),
	R8A73A4_PIN_IO_PU_PD(194), R8A73A4_PIN_IO_PU_PD(195),
	R8A73A4_PIN_IO_PU_PD(196), R8A73A4_PIN_IO_PU_PD(197),
	R8A73A4_PIN_IO_PU_PD(198), R8A73A4_PIN_IO_PU_PD(199),
	R8A73A4_PIN_IO_PU_PD(200), R8A73A4_PIN_IO_PU_PD(201),
	R8A73A4_PIN_IO_PU_PD(202), R8A73A4_PIN_IO_PU_PD(203),
	R8A73A4_PIN_IO_PU_PD(204), R8A73A4_PIN_IO_PU_PD(205),
	R8A73A4_PIN_IO_PU_PD(206), R8A73A4_PIN_IO_PU_PD(207),
	R8A73A4_PIN_IO_PU_PD(208), R8A73A4_PIN_IO_PU_PD(209),
	R8A73A4_PIN_IO_PU_PD(210), R8A73A4_PIN_IO_PU_PD(211),
	R8A73A4_PIN_IO_PU_PD(212), R8A73A4_PIN_IO_PU_PD(213),
	R8A73A4_PIN_IO_PU_PD(214), R8A73A4_PIN_IO_PU_PD(215),
	R8A73A4_PIN_IO_PU_PD(216), R8A73A4_PIN_IO_PU_PD(217),
	R8A73A4_PIN_IO_PU_PD(218), R8A73A4_PIN_IO_PU_PD(219),
	R8A73A4_PIN_IO_PU_PD(220), R8A73A4_PIN_IO_PU_PD(221),
	R8A73A4_PIN_IO_PU_PD(222),
	R8A73A4_PIN_IO_PU_PD(224), R8A73A4_PIN_IO_PU_PD(225),
	R8A73A4_PIN_IO_PU_PD(226), R8A73A4_PIN_IO_PU_PD(227),
	R8A73A4_PIN_IO_PU_PD(228), R8A73A4_PIN_IO_PU_PD(229),
	R8A73A4_PIN_IO_PU_PD(230), R8A73A4_PIN_IO_PU_PD(231),
	R8A73A4_PIN_IO_PU_PD(232), R8A73A4_PIN_IO_PU_PD(233),
	R8A73A4_PIN_IO_PU_PD(234), R8A73A4_PIN_IO_PU_PD(235),
	R8A73A4_PIN_IO_PU_PD(236), R8A73A4_PIN_IO_PU_PD(237),
	R8A73A4_PIN_IO_PU_PD(238), R8A73A4_PIN_IO_PU_PD(239),
	R8A73A4_PIN_IO_PU_PD(240), R8A73A4_PIN_IO_PU_PD(241),
	R8A73A4_PIN_IO_PU_PD(242), R8A73A4_PIN_IO_PU_PD(243),
	R8A73A4_PIN_IO_PU_PD(244), R8A73A4_PIN_IO_PU_PD(245),
	R8A73A4_PIN_IO_PU_PD(246), R8A73A4_PIN_IO_PU_PD(247),
	R8A73A4_PIN_IO_PU_PD(248), R8A73A4_PIN_IO_PU_PD(249),
	R8A73A4_PIN_IO_PU_PD(250),
	R8A73A4_PIN_IO_PU_PD(256), R8A73A4_PIN_IO_PU_PD(257),
	R8A73A4_PIN_IO_PU_PD(258), R8A73A4_PIN_IO_PU_PD(259),
	R8A73A4_PIN_IO_PU_PD(260), R8A73A4_PIN_IO_PU_PD(261),
	R8A73A4_PIN_IO_PU_PD(262), R8A73A4_PIN_IO_PU_PD(263),
	R8A73A4_PIN_IO_PU_PD(264), R8A73A4_PIN_IO_PU_PD(265),
	R8A73A4_PIN_IO_PU_PD(266), R8A73A4_PIN_IO_PU_PD(267),
	R8A73A4_PIN_IO_PU_PD(268), R8A73A4_PIN_IO_PU_PD(269),
	R8A73A4_PIN_IO_PU_PD(270), R8A73A4_PIN_IO_PU_PD(271),
	R8A73A4_PIN_IO_PU_PD(272), R8A73A4_PIN_IO_PU_PD(273),
	R8A73A4_PIN_IO_PU_PD(274), R8A73A4_PIN_IO_PU_PD(275),
	R8A73A4_PIN_IO_PU_PD(276), R8A73A4_PIN_IO_PU_PD(277),
	R8A73A4_PIN_IO_PU_PD(278), R8A73A4_PIN_IO_PU_PD(279),
	R8A73A4_PIN_IO_PU_PD(280), R8A73A4_PIN_IO_PU_PD(281),
	R8A73A4_PIN_IO_PU_PD(282), R8A73A4_PIN_IO_PU_PD(283),
	R8A73A4_PIN_O(288), R8A73A4_PIN_IO_PU_PD(289),
	R8A73A4_PIN_IO_PU_PD(290), R8A73A4_PIN_IO_PU_PD(291),
	R8A73A4_PIN_IO_PU_PD(292), R8A73A4_PIN_IO_PU_PD(293),
	R8A73A4_PIN_IO_PU_PD(294), R8A73A4_PIN_IO_PU_PD(295),
	R8A73A4_PIN_IO_PU_PD(296), R8A73A4_PIN_IO_PU_PD(297),
	R8A73A4_PIN_IO_PU_PD(298), R8A73A4_PIN_IO_PU_PD(299),
	R8A73A4_PIN_IO_PU_PD(300), R8A73A4_PIN_IO_PU_PD(301),
	R8A73A4_PIN_IO_PU_PD(302), R8A73A4_PIN_IO_PU_PD(303),
	R8A73A4_PIN_IO_PU_PD(304), R8A73A4_PIN_IO_PU_PD(305),
	R8A73A4_PIN_IO_PU_PD(306), R8A73A4_PIN_IO_PU_PD(307),
	R8A73A4_PIN_IO_PU_PD(308),
	R8A73A4_PIN_IO_PU_PD(320), R8A73A4_PIN_IO_PU_PD(321),
	R8A73A4_PIN_IO_PU_PD(322), R8A73A4_PIN_IO_PU_PD(323),
	R8A73A4_PIN_IO_PU_PD(324), R8A73A4_PIN_IO_PU_PD(325),
	R8A73A4_PIN_IO_PU_PD(326), R8A73A4_PIN_IO_PU_PD(327),
	R8A73A4_PIN_IO_PU_PD(328), R8A73A4_PIN_IO_PU_PD(329),
};

/* - IRQC ------------------------------------------------------------------- */
#define IRQC_PINS_MUX(pin, irq_mark)				\
static const unsigned int irqc_irq##irq_mark##_pins[] = {	\
	pin,							\
};								\
static const unsigned int irqc_irq##irq_mark##_mux[] = {	\
	IRQ##irq_mark##_MARK,					\
}
IRQC_PINS_MUX(0, 0);
IRQC_PINS_MUX(1, 1);
IRQC_PINS_MUX(2, 2);
IRQC_PINS_MUX(3, 3);
IRQC_PINS_MUX(4, 4);
IRQC_PINS_MUX(5, 5);
IRQC_PINS_MUX(6, 6);
IRQC_PINS_MUX(7, 7);
IRQC_PINS_MUX(8, 8);
IRQC_PINS_MUX(9, 9);
IRQC_PINS_MUX(10, 10);
IRQC_PINS_MUX(11, 11);
IRQC_PINS_MUX(12, 12);
IRQC_PINS_MUX(13, 13);
IRQC_PINS_MUX(14, 14);
IRQC_PINS_MUX(15, 15);
IRQC_PINS_MUX(66, 40);
IRQC_PINS_MUX(84, 19);
IRQC_PINS_MUX(85, 18);
IRQC_PINS_MUX(102, 41);
IRQC_PINS_MUX(103, 42);
IRQC_PINS_MUX(109, 43);
IRQC_PINS_MUX(110, 44);
IRQC_PINS_MUX(111, 45);
IRQC_PINS_MUX(112, 46);
IRQC_PINS_MUX(113, 47);
IRQC_PINS_MUX(114, 48);
IRQC_PINS_MUX(115, 49);
IRQC_PINS_MUX(160, 20);
IRQC_PINS_MUX(161, 21);
IRQC_PINS_MUX(162, 22);
IRQC_PINS_MUX(163, 23);
IRQC_PINS_MUX(175, 24);
IRQC_PINS_MUX(176, 25);
IRQC_PINS_MUX(177, 26);
IRQC_PINS_MUX(178, 27);
IRQC_PINS_MUX(192, 31);
IRQC_PINS_MUX(193, 32);
IRQC_PINS_MUX(194, 33);
IRQC_PINS_MUX(195, 34);
IRQC_PINS_MUX(196, 35);
IRQC_PINS_MUX(197, 36);
IRQC_PINS_MUX(198, 37);
IRQC_PINS_MUX(199, 38);
IRQC_PINS_MUX(200, 39);
IRQC_PINS_MUX(290, 51);
IRQC_PINS_MUX(296, 52);
IRQC_PINS_MUX(301, 50);
IRQC_PINS_MUX(320, 16);
IRQC_PINS_MUX(321, 17);
IRQC_PINS_MUX(322, 28);
IRQC_PINS_MUX(323, 29);
IRQC_PINS_MUX(324, 30);
IRQC_PINS_MUX(325, 53);
IRQC_PINS_MUX(326, 54);
IRQC_PINS_MUX(327, 55);
IRQC_PINS_MUX(328, 56);
IRQC_PINS_MUX(329, 57);
/* - MMCIF0 ----------------------------------------------------------------- */
static const unsigned int mmc0_data1_pins[] = {
	/* D[0] */
	164,
};
static const unsigned int mmc0_data1_mux[] = {
	MMCD0_0_MARK,
};
static const unsigned int mmc0_data4_pins[] = {
	/* D[0:3] */
	164, 165, 166, 167,
};
static const unsigned int mmc0_data4_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
};
static const unsigned int mmc0_data8_pins[] = {
	/* D[0:7] */
	164, 165, 166, 167, 168, 169, 170, 171,
};
static const unsigned int mmc0_data8_mux[] = {
	MMCD0_0_MARK, MMCD0_1_MARK, MMCD0_2_MARK, MMCD0_3_MARK,
	MMCD0_4_MARK, MMCD0_5_MARK, MMCD0_6_MARK, MMCD0_7_MARK,
};
static const unsigned int mmc0_ctrl_pins[] = {
	/* CMD, CLK */
	172, 173,
};
static const unsigned int mmc0_ctrl_mux[] = {
	MMCCMD0_MARK, MMCCLK0_MARK,
};
/* - MMCIF1 ----------------------------------------------------------------- */
static const unsigned int mmc1_data1_pins[] = {
	/* D[0] */
	199,
};
static const unsigned int mmc1_data1_mux[] = {
	MMCD1_0_MARK,
};
static const unsigned int mmc1_data4_pins[] = {
	/* D[0:3] */
	199, 198, 197, 196,
};
static const unsigned int mmc1_data4_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
};
static const unsigned int mmc1_data8_pins[] = {
	/* D[0:7] */
	199, 198, 197, 196, 195, 194, 193, 192,
};
static const unsigned int mmc1_data8_mux[] = {
	MMCD1_0_MARK, MMCD1_1_MARK, MMCD1_2_MARK, MMCD1_3_MARK,
	MMCD1_4_MARK, MMCD1_5_MARK, MMCD1_6_MARK, MMCD1_7_MARK,
};
static const unsigned int mmc1_ctrl_pins[] = {
	/* CMD, CLK */
	200, 203,
};
static const unsigned int mmc1_ctrl_mux[] = {
	MMCCMD1_MARK, MMCCLK1_MARK,
};
/* - SCIFA0 ----------------------------------------------------------------- */
static const unsigned int scifa0_data_pins[] = {
	/* SCIFA0_RXD, SCIFA0_TXD */
	117, 116,
};
static const unsigned int scifa0_data_mux[] = {
	SCIFA0_RXD_MARK, SCIFA0_TXD_MARK,
};
static const unsigned int scifa0_clk_pins[] = {
	/* SCIFA0_SCK */
	34,
};
static const unsigned int scifa0_clk_mux[] = {
	SCIFA0_SCK_MARK,
};
static const unsigned int scifa0_ctrl_pins[] = {
	/* SCIFA0_RTS, SCIFA0_CTS */
	32, 33,
};
static const unsigned int scifa0_ctrl_mux[] = {
	SCIFA0_RTS_MARK, SCIFA0_CTS_MARK,
};
/* - SCIFA1 ----------------------------------------------------------------- */
static const unsigned int scifa1_data_pins[] = {
	/* SCIFA1_RXD, SCIFA1_TXD */
	119, 118,
};
static const unsigned int scifa1_data_mux[] = {
	SCIFA1_RXD_MARK, SCIFA1_TXD_MARK,
};
static const unsigned int scifa1_clk_pins[] = {
	/* SCIFA1_SCK */
	37,
};
static const unsigned int scifa1_clk_mux[] = {
	SCIFA1_SCK_MARK,
};
static const unsigned int scifa1_ctrl_pins[] = {
	/* SCIFA1_RTS, SCIFA1_CTS */
	35, 36,
};
static const unsigned int scifa1_ctrl_mux[] = {
	SCIFA1_RTS_MARK, SCIFA1_CTS_MARK,
};
/* - SCIFB0 ----------------------------------------------------------------- */
static const unsigned int scifb0_data_pins[] = {
	/* SCIFB0_RXD, SCIFB0_TXD */
	123, 122,
};
static const unsigned int scifb0_data_mux[] = {
	SCIFB0_RXD_MARK, SCIFB0_TXD_MARK,
};
static const unsigned int scifb0_clk_pins[] = {
	/* SCIFB0_SCK */
	40,
};
static const unsigned int scifb0_clk_mux[] = {
	SCIFB0_SCK_MARK,
};
static const unsigned int scifb0_ctrl_pins[] = {
	/* SCIFB0_RTS, SCIFB0_CTS */
	38, 39,
};
static const unsigned int scifb0_ctrl_mux[] = {
	SCIFB0_RTS_MARK, SCIFB0_CTS_MARK,
};
/* - SCIFB1 ----------------------------------------------------------------- */
static const unsigned int scifb1_data_pins[] = {
	/* SCIFB1_RXD, SCIFB1_TXD */
	27, 26,
};
static const unsigned int scifb1_data_mux[] = {
	SCIFB1_RXD_27_MARK, SCIFB1_TXD_26_MARK,
};
static const unsigned int scifb1_clk_pins[] = {
	/* SCIFB1_SCK */
	28,
};
static const unsigned int scifb1_clk_mux[] = {
	SCIFB1_SCK_28_MARK,
};
static const unsigned int scifb1_ctrl_pins[] = {
	/* SCIFB1_RTS, SCIFB1_CTS */
	24, 25,
};
static const unsigned int scifb1_ctrl_mux[] = {
	SCIFB1_RTS_24_MARK, SCIFB1_CTS_25_MARK,
};
static const unsigned int scifb1_data_b_pins[] = {
	/* SCIFB1_RXD, SCIFB1_TXD */
	72, 67,
};
static const unsigned int scifb1_data_b_mux[] = {
	SCIFB1_RXD_72_MARK, SCIFB1_TXD_67_MARK,
};
static const unsigned int scifb1_clk_b_pins[] = {
	/* SCIFB1_SCK */
	261,
};
static const unsigned int scifb1_clk_b_mux[] = {
	SCIFB1_SCK_261_MARK,
};
static const unsigned int scifb1_ctrl_b_pins[] = {
	/* SCIFB1_RTS, SCIFB1_CTS */
	70, 71,
};
static const unsigned int scifb1_ctrl_b_mux[] = {
	SCIFB1_RTS_70_MARK, SCIFB1_CTS_71_MARK,
};
/* - SCIFB2 ----------------------------------------------------------------- */
static const unsigned int scifb2_data_pins[] = {
	/* SCIFB2_RXD, SCIFB2_TXD */
	69, 68,
};
static const unsigned int scifb2_data_mux[] = {
	SCIFB2_RXD_69_MARK, SCIFB2_TXD_68_MARK,
};
static const unsigned int scifb2_clk_pins[] = {
	/* SCIFB2_SCK */
	262,
};
static const unsigned int scifb2_clk_mux[] = {
	SCIFB2_SCK_262_MARK,
};
static const unsigned int scifb2_ctrl_pins[] = {
	/* SCIFB2_RTS, SCIFB2_CTS */
	73, 66,
};
static const unsigned int scifb2_ctrl_mux[] = {
	SCIFB2_RTS_73_MARK, SCIFB2_CTS_66_MARK,
};
static const unsigned int scifb2_data_b_pins[] = {
	/* SCIFB2_RXD, SCIFB2_TXD */
	297, 295,
};
static const unsigned int scifb2_data_b_mux[] = {
	SCIFB2_RXD_297_MARK, SCIFB2_TXD_295_MARK,
};
static const unsigned int scifb2_clk_b_pins[] = {
	/* SCIFB2_SCK */
	299,
};
static const unsigned int scifb2_clk_b_mux[] = {
	SCIFB2_SCK_299_MARK,
};
static const unsigned int scifb2_ctrl_b_pins[] = {
	/* SCIFB2_RTS, SCIFB2_CTS */
	300, 298,
};
static const unsigned int scifb2_ctrl_b_mux[] = {
	SCIFB2_RTS_300_MARK, SCIFB2_CTS_298_MARK,
};
/* - SCIFB3 ----------------------------------------------------------------- */
static const unsigned int scifb3_data_pins[] = {
	/* SCIFB3_RXD, SCIFB3_TXD */
	22, 21,
};
static const unsigned int scifb3_data_mux[] = {
	SCIFB3_RXD_22_MARK, SCIFB3_TXD_21_MARK,
};
static const unsigned int scifb3_clk_pins[] = {
	/* SCIFB3_SCK */
	23,
};
static const unsigned int scifb3_clk_mux[] = {
	SCIFB3_SCK_23_MARK,
};
static const unsigned int scifb3_ctrl_pins[] = {
	/* SCIFB3_RTS, SCIFB3_CTS */
	19, 20,
};
static const unsigned int scifb3_ctrl_mux[] = {
	SCIFB3_RTS_19_MARK, SCIFB3_CTS_20_MARK,
};
static const unsigned int scifb3_data_b_pins[] = {
	/* SCIFB3_RXD, SCIFB3_TXD */
	120, 121,
};
static const unsigned int scifb3_data_b_mux[] = {
	SCIFB3_RXD_120_MARK, SCIFB3_TXD_121_MARK,
};
static const unsigned int scifb3_clk_b_pins[] = {
	/* SCIFB3_SCK */
	40,
};
static const unsigned int scifb3_clk_b_mux[] = {
	SCIFB3_SCK_40_MARK,
};
static const unsigned int scifb3_ctrl_b_pins[] = {
	/* SCIFB3_RTS, SCIFB3_CTS */
	38, 39,
};
static const unsigned int scifb3_ctrl_b_mux[] = {
	SCIFB3_RTS_38_MARK, SCIFB3_CTS_39_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	302,
};
static const unsigned int sdhi0_data1_mux[] = {
	SDHID0_0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	302, 303, 304, 305,
};
static const unsigned int sdhi0_data4_mux[] = {
	SDHID0_0_MARK, SDHID0_1_MARK, SDHID0_2_MARK, SDHID0_3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CLK, CMD */
	308, 306,
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SDHICLK0_MARK, SDHICMD0_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	301,
};
static const unsigned int sdhi0_cd_mux[] = {
	SDHICD0_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	307,
};
static const unsigned int sdhi0_wp_mux[] = {
	SDHIWP0_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	289,
};
static const unsigned int sdhi1_data1_mux[] = {
	SDHID1_0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	289, 290, 291, 292,
};
static const unsigned int sdhi1_data4_mux[] = {
	SDHID1_0_MARK, SDHID1_1_MARK, SDHID1_2_MARK, SDHID1_3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CLK, CMD */
	293, 294,
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SDHICLK1_MARK, SDHICMD1_MARK,
};
/* - SDHI2 ------------------------------------------------------------------ */
static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	295,
};
static const unsigned int sdhi2_data1_mux[] = {
	SDHID2_0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	295, 296, 297, 298,
};
static const unsigned int sdhi2_data4_mux[] = {
	SDHID2_0_MARK, SDHID2_1_MARK, SDHID2_2_MARK, SDHID2_3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CLK, CMD */
	299, 300,
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SDHICLK2_MARK, SDHICMD2_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(irqc_irq0),
	SH_PFC_PIN_GROUP(irqc_irq1),
	SH_PFC_PIN_GROUP(irqc_irq2),
	SH_PFC_PIN_GROUP(irqc_irq3),
	SH_PFC_PIN_GROUP(irqc_irq4),
	SH_PFC_PIN_GROUP(irqc_irq5),
	SH_PFC_PIN_GROUP(irqc_irq6),
	SH_PFC_PIN_GROUP(irqc_irq7),
	SH_PFC_PIN_GROUP(irqc_irq8),
	SH_PFC_PIN_GROUP(irqc_irq9),
	SH_PFC_PIN_GROUP(irqc_irq10),
	SH_PFC_PIN_GROUP(irqc_irq11),
	SH_PFC_PIN_GROUP(irqc_irq12),
	SH_PFC_PIN_GROUP(irqc_irq13),
	SH_PFC_PIN_GROUP(irqc_irq14),
	SH_PFC_PIN_GROUP(irqc_irq15),
	SH_PFC_PIN_GROUP(irqc_irq16),
	SH_PFC_PIN_GROUP(irqc_irq17),
	SH_PFC_PIN_GROUP(irqc_irq18),
	SH_PFC_PIN_GROUP(irqc_irq19),
	SH_PFC_PIN_GROUP(irqc_irq20),
	SH_PFC_PIN_GROUP(irqc_irq21),
	SH_PFC_PIN_GROUP(irqc_irq22),
	SH_PFC_PIN_GROUP(irqc_irq23),
	SH_PFC_PIN_GROUP(irqc_irq24),
	SH_PFC_PIN_GROUP(irqc_irq25),
	SH_PFC_PIN_GROUP(irqc_irq26),
	SH_PFC_PIN_GROUP(irqc_irq27),
	SH_PFC_PIN_GROUP(irqc_irq28),
	SH_PFC_PIN_GROUP(irqc_irq29),
	SH_PFC_PIN_GROUP(irqc_irq30),
	SH_PFC_PIN_GROUP(irqc_irq31),
	SH_PFC_PIN_GROUP(irqc_irq32),
	SH_PFC_PIN_GROUP(irqc_irq33),
	SH_PFC_PIN_GROUP(irqc_irq34),
	SH_PFC_PIN_GROUP(irqc_irq35),
	SH_PFC_PIN_GROUP(irqc_irq36),
	SH_PFC_PIN_GROUP(irqc_irq37),
	SH_PFC_PIN_GROUP(irqc_irq38),
	SH_PFC_PIN_GROUP(irqc_irq39),
	SH_PFC_PIN_GROUP(irqc_irq40),
	SH_PFC_PIN_GROUP(irqc_irq41),
	SH_PFC_PIN_GROUP(irqc_irq42),
	SH_PFC_PIN_GROUP(irqc_irq43),
	SH_PFC_PIN_GROUP(irqc_irq44),
	SH_PFC_PIN_GROUP(irqc_irq45),
	SH_PFC_PIN_GROUP(irqc_irq46),
	SH_PFC_PIN_GROUP(irqc_irq47),
	SH_PFC_PIN_GROUP(irqc_irq48),
	SH_PFC_PIN_GROUP(irqc_irq49),
	SH_PFC_PIN_GROUP(irqc_irq50),
	SH_PFC_PIN_GROUP(irqc_irq51),
	SH_PFC_PIN_GROUP(irqc_irq52),
	SH_PFC_PIN_GROUP(irqc_irq53),
	SH_PFC_PIN_GROUP(irqc_irq54),
	SH_PFC_PIN_GROUP(irqc_irq55),
	SH_PFC_PIN_GROUP(irqc_irq56),
	SH_PFC_PIN_GROUP(irqc_irq57),
	SH_PFC_PIN_GROUP(mmc0_data1),
	SH_PFC_PIN_GROUP(mmc0_data4),
	SH_PFC_PIN_GROUP(mmc0_data8),
	SH_PFC_PIN_GROUP(mmc0_ctrl),
	SH_PFC_PIN_GROUP(mmc1_data1),
	SH_PFC_PIN_GROUP(mmc1_data4),
	SH_PFC_PIN_GROUP(mmc1_data8),
	SH_PFC_PIN_GROUP(mmc1_ctrl),
	SH_PFC_PIN_GROUP(scifa0_data),
	SH_PFC_PIN_GROUP(scifa0_clk),
	SH_PFC_PIN_GROUP(scifa0_ctrl),
	SH_PFC_PIN_GROUP(scifa1_data),
	SH_PFC_PIN_GROUP(scifa1_clk),
	SH_PFC_PIN_GROUP(scifa1_ctrl),
	SH_PFC_PIN_GROUP(scifb0_data),
	SH_PFC_PIN_GROUP(scifb0_clk),
	SH_PFC_PIN_GROUP(scifb0_ctrl),
	SH_PFC_PIN_GROUP(scifb1_data),
	SH_PFC_PIN_GROUP(scifb1_clk),
	SH_PFC_PIN_GROUP(scifb1_ctrl),
	SH_PFC_PIN_GROUP(scifb1_data_b),
	SH_PFC_PIN_GROUP(scifb1_clk_b),
	SH_PFC_PIN_GROUP(scifb1_ctrl_b),
	SH_PFC_PIN_GROUP(scifb2_data),
	SH_PFC_PIN_GROUP(scifb2_clk),
	SH_PFC_PIN_GROUP(scifb2_ctrl),
	SH_PFC_PIN_GROUP(scifb2_data_b),
	SH_PFC_PIN_GROUP(scifb2_clk_b),
	SH_PFC_PIN_GROUP(scifb2_ctrl_b),
	SH_PFC_PIN_GROUP(scifb3_data),
	SH_PFC_PIN_GROUP(scifb3_clk),
	SH_PFC_PIN_GROUP(scifb3_ctrl),
	SH_PFC_PIN_GROUP(scifb3_data_b),
	SH_PFC_PIN_GROUP(scifb3_clk_b),
	SH_PFC_PIN_GROUP(scifb3_ctrl_b),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
};

static const char * const irqc_groups[] = {
	"irqc_irq0",
	"irqc_irq1",
	"irqc_irq2",
	"irqc_irq3",
	"irqc_irq4",
	"irqc_irq5",
	"irqc_irq6",
	"irqc_irq7",
	"irqc_irq8",
	"irqc_irq9",
	"irqc_irq10",
	"irqc_irq11",
	"irqc_irq12",
	"irqc_irq13",
	"irqc_irq14",
	"irqc_irq15",
	"irqc_irq16",
	"irqc_irq17",
	"irqc_irq18",
	"irqc_irq19",
	"irqc_irq20",
	"irqc_irq21",
	"irqc_irq22",
	"irqc_irq23",
	"irqc_irq24",
	"irqc_irq25",
	"irqc_irq26",
	"irqc_irq27",
	"irqc_irq28",
	"irqc_irq29",
	"irqc_irq30",
	"irqc_irq31",
	"irqc_irq32",
	"irqc_irq33",
	"irqc_irq34",
	"irqc_irq35",
	"irqc_irq36",
	"irqc_irq37",
	"irqc_irq38",
	"irqc_irq39",
	"irqc_irq40",
	"irqc_irq41",
	"irqc_irq42",
	"irqc_irq43",
	"irqc_irq44",
	"irqc_irq45",
	"irqc_irq46",
	"irqc_irq47",
	"irqc_irq48",
	"irqc_irq49",
	"irqc_irq50",
	"irqc_irq51",
	"irqc_irq52",
	"irqc_irq53",
	"irqc_irq54",
	"irqc_irq55",
	"irqc_irq56",
	"irqc_irq57",
};

static const char * const mmc0_groups[] = {
	"mmc0_data1",
	"mmc0_data4",
	"mmc0_data8",
	"mmc0_ctrl",
};

static const char * const mmc1_groups[] = {
	"mmc1_data1",
	"mmc1_data4",
	"mmc1_data8",
	"mmc1_ctrl",
};

static const char * const scifa0_groups[] = {
	"scifa0_data",
	"scifa0_clk",
	"scifa0_ctrl",
};

static const char * const scifa1_groups[] = {
	"scifa1_data",
	"scifa1_clk",
	"scifa1_ctrl",
};

static const char * const scifb0_groups[] = {
	"scifb0_data",
	"scifb0_clk",
	"scifb0_ctrl",
};

static const char * const scifb1_groups[] = {
	"scifb1_data",
	"scifb1_clk",
	"scifb1_ctrl",
	"scifb1_data_b",
	"scifb1_clk_b",
	"scifb1_ctrl_b",
};

static const char * const scifb2_groups[] = {
	"scifb2_data",
	"scifb2_clk",
	"scifb2_ctrl",
	"scifb2_data_b",
	"scifb2_clk_b",
	"scifb2_ctrl_b",
};

static const char * const scifb3_groups[] = {
	"scifb3_data",
	"scifb3_clk",
	"scifb3_ctrl",
	"scifb3_data_b",
	"scifb3_clk_b",
	"scifb3_ctrl_b",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(irqc),
	SH_PFC_FUNCTION(mmc0),
	SH_PFC_FUNCTION(mmc1),
	SH_PFC_FUNCTION(scifa0),
	SH_PFC_FUNCTION(scifa1),
	SH_PFC_FUNCTION(scifb0),
	SH_PFC_FUNCTION(scifb1),
	SH_PFC_FUNCTION(scifb2),
	SH_PFC_FUNCTION(scifb3),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	PORTCR(0, 0xe6050000),
	PORTCR(1, 0xe6050001),
	PORTCR(2, 0xe6050002),
	PORTCR(3, 0xe6050003),
	PORTCR(4, 0xe6050004),
	PORTCR(5, 0xe6050005),
	PORTCR(6, 0xe6050006),
	PORTCR(7, 0xe6050007),
	PORTCR(8, 0xe6050008),
	PORTCR(9, 0xe6050009),
	PORTCR(10, 0xe605000A),
	PORTCR(11, 0xe605000B),
	PORTCR(12, 0xe605000C),
	PORTCR(13, 0xe605000D),
	PORTCR(14, 0xe605000E),
	PORTCR(15, 0xe605000F),
	PORTCR(16, 0xe6050010),
	PORTCR(17, 0xe6050011),
	PORTCR(18, 0xe6050012),
	PORTCR(19, 0xe6050013),
	PORTCR(20, 0xe6050014),
	PORTCR(21, 0xe6050015),
	PORTCR(22, 0xe6050016),
	PORTCR(23, 0xe6050017),
	PORTCR(24, 0xe6050018),
	PORTCR(25, 0xe6050019),
	PORTCR(26, 0xe605001A),
	PORTCR(27, 0xe605001B),
	PORTCR(28, 0xe605001C),
	PORTCR(29, 0xe605001D),
	PORTCR(30, 0xe605001E),
	PORTCR(32, 0xe6051020),
	PORTCR(33, 0xe6051021),
	PORTCR(34, 0xe6051022),
	PORTCR(35, 0xe6051023),
	PORTCR(36, 0xe6051024),
	PORTCR(37, 0xe6051025),
	PORTCR(38, 0xe6051026),
	PORTCR(39, 0xe6051027),
	PORTCR(40, 0xe6051028),
	PORTCR(64, 0xe6050040),
	PORTCR(65, 0xe6050041),
	PORTCR(66, 0xe6050042),
	PORTCR(67, 0xe6050043),
	PORTCR(68, 0xe6050044),
	PORTCR(69, 0xe6050045),
	PORTCR(70, 0xe6050046),
	PORTCR(71, 0xe6050047),
	PORTCR(72, 0xe6050048),
	PORTCR(73, 0xe6050049),
	PORTCR(74, 0xe605004A),
	PORTCR(75, 0xe605004B),
	PORTCR(76, 0xe605004C),
	PORTCR(77, 0xe605004D),
	PORTCR(78, 0xe605004E),
	PORTCR(79, 0xe605004F),
	PORTCR(80, 0xe6050050),
	PORTCR(81, 0xe6050051),
	PORTCR(82, 0xe6050052),
	PORTCR(83, 0xe6050053),
	PORTCR(84, 0xe6050054),
	PORTCR(85, 0xe6050055),
	PORTCR(96, 0xe6051060),
	PORTCR(97, 0xe6051061),
	PORTCR(98, 0xe6051062),
	PORTCR(99, 0xe6051063),
	PORTCR(100, 0xe6051064),
	PORTCR(101, 0xe6051065),
	PORTCR(102, 0xe6051066),
	PORTCR(103, 0xe6051067),
	PORTCR(104, 0xe6051068),
	PORTCR(105, 0xe6051069),
	PORTCR(106, 0xe605106A),
	PORTCR(107, 0xe605106B),
	PORTCR(108, 0xe605106C),
	PORTCR(109, 0xe605106D),
	PORTCR(110, 0xe605106E),
	PORTCR(111, 0xe605106F),
	PORTCR(112, 0xe6051070),
	PORTCR(113, 0xe6051071),
	PORTCR(114, 0xe6051072),
	PORTCR(115, 0xe6051073),
	PORTCR(116, 0xe6051074),
	PORTCR(117, 0xe6051075),
	PORTCR(118, 0xe6051076),
	PORTCR(119, 0xe6051077),
	PORTCR(120, 0xe6051078),
	PORTCR(121, 0xe6051079),
	PORTCR(122, 0xe605107A),
	PORTCR(123, 0xe605107B),
	PORTCR(124, 0xe605107C),
	PORTCR(125, 0xe605107D),
	PORTCR(126, 0xe605107E),
	PORTCR(128, 0xe6051080),
	PORTCR(129, 0xe6051081),
	PORTCR(130, 0xe6051082),
	PORTCR(131, 0xe6051083),
	PORTCR(132, 0xe6051084),
	PORTCR(133, 0xe6051085),
	PORTCR(134, 0xe6051086),
	PORTCR(160, 0xe60520A0),
	PORTCR(161, 0xe60520A1),
	PORTCR(162, 0xe60520A2),
	PORTCR(163, 0xe60520A3),
	PORTCR(164, 0xe60520A4),
	PORTCR(165, 0xe60520A5),
	PORTCR(166, 0xe60520A6),
	PORTCR(167, 0xe60520A7),
	PORTCR(168, 0xe60520A8),
	PORTCR(169, 0xe60520A9),
	PORTCR(170, 0xe60520AA),
	PORTCR(171, 0xe60520AB),
	PORTCR(172, 0xe60520AC),
	PORTCR(173, 0xe60520AD),
	PORTCR(174, 0xe60520AE),
	PORTCR(175, 0xe60520AF),
	PORTCR(176, 0xe60520B0),
	PORTCR(177, 0xe60520B1),
	PORTCR(178, 0xe60520B2),
	PORTCR(192, 0xe60520C0),
	PORTCR(193, 0xe60520C1),
	PORTCR(194, 0xe60520C2),
	PORTCR(195, 0xe60520C3),
	PORTCR(196, 0xe60520C4),
	PORTCR(197, 0xe60520C5),
	PORTCR(198, 0xe60520C6),
	PORTCR(199, 0xe60520C7),
	PORTCR(200, 0xe60520C8),
	PORTCR(201, 0xe60520C9),
	PORTCR(202, 0xe60520CA),
	PORTCR(203, 0xe60520CB),
	PORTCR(204, 0xe60520CC),
	PORTCR(205, 0xe60520CD),
	PORTCR(206, 0xe60520CE),
	PORTCR(207, 0xe60520CF),
	PORTCR(208, 0xe60520D0),
	PORTCR(209, 0xe60520D1),
	PORTCR(210, 0xe60520D2),
	PORTCR(211, 0xe60520D3),
	PORTCR(212, 0xe60520D4),
	PORTCR(213, 0xe60520D5),
	PORTCR(214, 0xe60520D6),
	PORTCR(215, 0xe60520D7),
	PORTCR(216, 0xe60520D8),
	PORTCR(217, 0xe60520D9),
	PORTCR(218, 0xe60520DA),
	PORTCR(219, 0xe60520DB),
	PORTCR(220, 0xe60520DC),
	PORTCR(221, 0xe60520DD),
	PORTCR(222, 0xe60520DE),
	PORTCR(224, 0xe60520E0),
	PORTCR(225, 0xe60520E1),
	PORTCR(226, 0xe60520E2),
	PORTCR(227, 0xe60520E3),
	PORTCR(228, 0xe60520E4),
	PORTCR(229, 0xe60520E5),
	PORTCR(230, 0xe60520e6),
	PORTCR(231, 0xe60520E7),
	PORTCR(232, 0xe60520E8),
	PORTCR(233, 0xe60520E9),
	PORTCR(234, 0xe60520EA),
	PORTCR(235, 0xe60520EB),
	PORTCR(236, 0xe60520EC),
	PORTCR(237, 0xe60520ED),
	PORTCR(238, 0xe60520EE),
	PORTCR(239, 0xe60520EF),
	PORTCR(240, 0xe60520F0),
	PORTCR(241, 0xe60520F1),
	PORTCR(242, 0xe60520F2),
	PORTCR(243, 0xe60520F3),
	PORTCR(244, 0xe60520F4),
	PORTCR(245, 0xe60520F5),
	PORTCR(246, 0xe60520F6),
	PORTCR(247, 0xe60520F7),
	PORTCR(248, 0xe60520F8),
	PORTCR(249, 0xe60520F9),
	PORTCR(250, 0xe60520FA),
	PORTCR(256, 0xe6052100),
	PORTCR(257, 0xe6052101),
	PORTCR(258, 0xe6052102),
	PORTCR(259, 0xe6052103),
	PORTCR(260, 0xe6052104),
	PORTCR(261, 0xe6052105),
	PORTCR(262, 0xe6052106),
	PORTCR(263, 0xe6052107),
	PORTCR(264, 0xe6052108),
	PORTCR(265, 0xe6052109),
	PORTCR(266, 0xe605210A),
	PORTCR(267, 0xe605210B),
	PORTCR(268, 0xe605210C),
	PORTCR(269, 0xe605210D),
	PORTCR(270, 0xe605210E),
	PORTCR(271, 0xe605210F),
	PORTCR(272, 0xe6052110),
	PORTCR(273, 0xe6052111),
	PORTCR(274, 0xe6052112),
	PORTCR(275, 0xe6052113),
	PORTCR(276, 0xe6052114),
	PORTCR(277, 0xe6052115),
	PORTCR(278, 0xe6052116),
	PORTCR(279, 0xe6052117),
	PORTCR(280, 0xe6052118),
	PORTCR(281, 0xe6052119),
	PORTCR(282, 0xe605211A),
	PORTCR(283, 0xe605211B),
	PORTCR(288, 0xe6053120),
	PORTCR(289, 0xe6053121),
	PORTCR(290, 0xe6053122),
	PORTCR(291, 0xe6053123),
	PORTCR(292, 0xe6053124),
	PORTCR(293, 0xe6053125),
	PORTCR(294, 0xe6053126),
	PORTCR(295, 0xe6053127),
	PORTCR(296, 0xe6053128),
	PORTCR(297, 0xe6053129),
	PORTCR(298, 0xe605312A),
	PORTCR(299, 0xe605312B),
	PORTCR(300, 0xe605312C),
	PORTCR(301, 0xe605312D),
	PORTCR(302, 0xe605312E),
	PORTCR(303, 0xe605312F),
	PORTCR(304, 0xe6053130),
	PORTCR(305, 0xe6053131),
	PORTCR(306, 0xe6053132),
	PORTCR(307, 0xe6053133),
	PORTCR(308, 0xe6053134),
	PORTCR(320, 0xe6053140),
	PORTCR(321, 0xe6053141),
	PORTCR(322, 0xe6053142),
	PORTCR(323, 0xe6053143),
	PORTCR(324, 0xe6053144),
	PORTCR(325, 0xe6053145),
	PORTCR(326, 0xe6053146),
	PORTCR(327, 0xe6053147),
	PORTCR(328, 0xe6053148),
	PORTCR(329, 0xe6053149),

	{ PINMUX_CFG_REG("MSEL1CR", 0xe605800c, 32, 1) {
			MSEL1CR_31_0, MSEL1CR_31_1,
			0, 0,
			0, 0,
			0, 0,
			MSEL1CR_27_0, MSEL1CR_27_1,
			0, 0,
			MSEL1CR_25_0, MSEL1CR_25_1,
			MSEL1CR_24_0, MSEL1CR_24_1,
			0, 0,
			MSEL1CR_22_0, MSEL1CR_22_1,
			MSEL1CR_21_0, MSEL1CR_21_1,
			MSEL1CR_20_0, MSEL1CR_20_1,
			MSEL1CR_19_0, MSEL1CR_19_1,
			MSEL1CR_18_0, MSEL1CR_18_1,
			MSEL1CR_17_0, MSEL1CR_17_1,
			MSEL1CR_16_0, MSEL1CR_16_1,
			MSEL1CR_15_0, MSEL1CR_15_1,
			MSEL1CR_14_0, MSEL1CR_14_1,
			MSEL1CR_13_0, MSEL1CR_13_1,
			MSEL1CR_12_0, MSEL1CR_12_1,
			MSEL1CR_11_0, MSEL1CR_11_1,
			MSEL1CR_10_0, MSEL1CR_10_1,
			MSEL1CR_09_0, MSEL1CR_09_1,
			MSEL1CR_08_0, MSEL1CR_08_1,
			MSEL1CR_07_0, MSEL1CR_07_1,
			MSEL1CR_06_0, MSEL1CR_06_1,
			MSEL1CR_05_0, MSEL1CR_05_1,
			MSEL1CR_04_0, MSEL1CR_04_1,
			MSEL1CR_03_0, MSEL1CR_03_1,
			MSEL1CR_02_0, MSEL1CR_02_1,
			MSEL1CR_01_0, MSEL1CR_01_1,
			MSEL1CR_00_0, MSEL1CR_00_1,
		}
	},
	{ PINMUX_CFG_REG("MSEL3CR", 0xe6058020, 32, 1) {
			MSEL3CR_31_0, MSEL3CR_31_1,
			0, 0,
			0, 0,
			MSEL3CR_28_0, MSEL3CR_28_1,
			MSEL3CR_27_0, MSEL3CR_27_1,
			MSEL3CR_26_0, MSEL3CR_26_1,
			0, 0,
			0, 0,
			MSEL3CR_23_0, MSEL3CR_23_1,
			MSEL3CR_22_0, MSEL3CR_22_1,
			MSEL3CR_21_0, MSEL3CR_21_1,
			MSEL3CR_20_0, MSEL3CR_20_1,
			MSEL3CR_19_0, MSEL3CR_19_1,
			MSEL3CR_18_0, MSEL3CR_18_1,
			MSEL3CR_17_0, MSEL3CR_17_1,
			MSEL3CR_16_0, MSEL3CR_16_1,
			MSEL3CR_15_0, MSEL3CR_15_1,
			0, 0,
			0, 0,
			MSEL3CR_12_0, MSEL3CR_12_1,
			MSEL3CR_11_0, MSEL3CR_11_1,
			MSEL3CR_10_0, MSEL3CR_10_1,
			MSEL3CR_09_0, MSEL3CR_09_1,
			0, 0,
			0, 0,
			MSEL3CR_06_0, MSEL3CR_06_1,
			0, 0,
			0, 0,
			MSEL3CR_03_0, MSEL3CR_03_1,
			0, 0,
			MSEL3CR_01_0, MSEL3CR_01_1,
			MSEL3CR_00_0, MSEL3CR_00_1,
			}
	},
	{ PINMUX_CFG_REG("MSEL4CR", 0xe6058024, 32, 1) {
			0, 0,
			MSEL4CR_30_0, MSEL4CR_30_1,
			MSEL4CR_29_0, MSEL4CR_29_1,
			MSEL4CR_28_0, MSEL4CR_28_1,
			MSEL4CR_27_0, MSEL4CR_27_1,
			MSEL4CR_26_0, MSEL4CR_26_1,
			MSEL4CR_25_0, MSEL4CR_25_1,
			MSEL4CR_24_0, MSEL4CR_24_1,
			MSEL4CR_23_0, MSEL4CR_23_1,
			MSEL4CR_22_0, MSEL4CR_22_1,
			MSEL4CR_21_0, MSEL4CR_21_1,
			MSEL4CR_20_0, MSEL4CR_20_1,
			MSEL4CR_19_0, MSEL4CR_19_1,
			MSEL4CR_18_0, MSEL4CR_18_1,
			MSEL4CR_17_0, MSEL4CR_17_1,
			MSEL4CR_16_0, MSEL4CR_16_1,
			MSEL4CR_15_0, MSEL4CR_15_1,
			MSEL4CR_14_0, MSEL4CR_14_1,
			MSEL4CR_13_0, MSEL4CR_13_1,
			MSEL4CR_12_0, MSEL4CR_12_1,
			MSEL4CR_11_0, MSEL4CR_11_1,
			MSEL4CR_10_0, MSEL4CR_10_1,
			MSEL4CR_09_0, MSEL4CR_09_1,
			0, 0,
			MSEL4CR_07_0, MSEL4CR_07_1,
			0, 0,
			0, 0,
			MSEL4CR_04_0, MSEL4CR_04_1,
			0, 0,
			0, 0,
			MSEL4CR_01_0, MSEL4CR_01_1,
			0, 0,
		}
	},
	{ PINMUX_CFG_REG("MSEL5CR", 0xe6058028, 32, 1) {
			MSEL5CR_31_0, MSEL5CR_31_1,
			MSEL5CR_30_0, MSEL5CR_30_1,
			MSEL5CR_29_0, MSEL5CR_29_1,
			MSEL5CR_28_0, MSEL5CR_28_1,
			MSEL5CR_27_0, MSEL5CR_27_1,
			MSEL5CR_26_0, MSEL5CR_26_1,
			MSEL5CR_25_0, MSEL5CR_25_1,
			MSEL5CR_24_0, MSEL5CR_24_1,
			MSEL5CR_23_0, MSEL5CR_23_1,
			MSEL5CR_22_0, MSEL5CR_22_1,
			MSEL5CR_21_0, MSEL5CR_21_1,
			MSEL5CR_20_0, MSEL5CR_20_1,
			MSEL5CR_19_0, MSEL5CR_19_1,
			MSEL5CR_18_0, MSEL5CR_18_1,
			MSEL5CR_17_0, MSEL5CR_17_1,
			MSEL5CR_16_0, MSEL5CR_16_1,
			MSEL5CR_15_0, MSEL5CR_15_1,
			MSEL5CR_14_0, MSEL5CR_14_1,
			MSEL5CR_13_0, MSEL5CR_13_1,
			MSEL5CR_12_0, MSEL5CR_12_1,
			MSEL5CR_11_0, MSEL5CR_11_1,
			MSEL5CR_10_0, MSEL5CR_10_1,
			MSEL5CR_09_0, MSEL5CR_09_1,
			MSEL5CR_08_0, MSEL5CR_08_1,
			MSEL5CR_07_0, MSEL5CR_07_1,
			MSEL5CR_06_0, MSEL5CR_06_1,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
		}
	},
	{ PINMUX_CFG_REG("MSEL8CR", 0xe6058034, 32, 1) {
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			MSEL8CR_16_0, MSEL8CR_16_1,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			0, 0,
			MSEL8CR_01_0, MSEL8CR_01_1,
			MSEL8CR_00_0, MSEL8CR_00_1,
		}
	},
	{ },
};

static const struct pinmux_data_reg pinmux_data_regs[] = {

	{ PINMUX_DATA_REG("PORTL031_000DR", 0xe6054000, 32) {
			0, PORT30_DATA, PORT29_DATA, PORT28_DATA,
			PORT27_DATA, PORT26_DATA, PORT25_DATA, PORT24_DATA,
			PORT23_DATA, PORT22_DATA, PORT21_DATA, PORT20_DATA,
			PORT19_DATA, PORT18_DATA, PORT17_DATA, PORT16_DATA,
			PORT15_DATA, PORT14_DATA, PORT13_DATA, PORT12_DATA,
			PORT11_DATA, PORT10_DATA, PORT9_DATA, PORT8_DATA,
			PORT7_DATA, PORT6_DATA, PORT5_DATA, PORT4_DATA,
			PORT3_DATA, PORT2_DATA, PORT1_DATA, PORT0_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD063_032DR", 0xe6055000, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, PORT40_DATA,
			PORT39_DATA, PORT38_DATA, PORT37_DATA, PORT36_DATA,
			PORT35_DATA, PORT34_DATA, PORT33_DATA, PORT32_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTL095_064DR", 0xe6054004, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, PORT85_DATA, PORT84_DATA,
			PORT83_DATA, PORT82_DATA, PORT81_DATA, PORT80_DATA,
			PORT79_DATA, PORT78_DATA, PORT77_DATA, PORT76_DATA,
			PORT75_DATA, PORT74_DATA, PORT73_DATA, PORT72_DATA,
			PORT71_DATA, PORT70_DATA, PORT69_DATA, PORT68_DATA,
			PORT67_DATA, PORT66_DATA, PORT65_DATA, PORT64_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD127_096DR", 0xe6055004, 32) {
			0, PORT126_DATA, PORT125_DATA, PORT124_DATA,
			PORT123_DATA, PORT122_DATA, PORT121_DATA, PORT120_DATA,
			PORT119_DATA, PORT118_DATA, PORT117_DATA, PORT116_DATA,
			PORT115_DATA, PORT114_DATA, PORT113_DATA, PORT112_DATA,
			PORT111_DATA, PORT110_DATA, PORT109_DATA, PORT108_DATA,
			PORT107_DATA, PORT106_DATA, PORT105_DATA, PORT104_DATA,
			PORT103_DATA, PORT102_DATA, PORT101_DATA, PORT100_DATA,
			PORT99_DATA, PORT98_DATA, PORT97_DATA, PORT96_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTD159_128DR", 0xe6055008, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, PORT134_DATA, PORT133_DATA, PORT132_DATA,
			PORT131_DATA, PORT130_DATA, PORT129_DATA, PORT128_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR191_160DR", 0xe6056000, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, PORT178_DATA, PORT177_DATA, PORT176_DATA,
			PORT175_DATA, PORT174_DATA, PORT173_DATA, PORT172_DATA,
			PORT171_DATA, PORT170_DATA, PORT169_DATA, PORT168_DATA,
			PORT167_DATA, PORT166_DATA, PORT165_DATA, PORT164_DATA,
			PORT163_DATA, PORT162_DATA, PORT161_DATA, PORT160_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR223_192DR", 0xe6056004, 32) {
			0, PORT222_DATA, PORT221_DATA, PORT220_DATA,
			PORT219_DATA, PORT218_DATA, PORT217_DATA, PORT216_DATA,
			PORT215_DATA, PORT214_DATA, PORT213_DATA, PORT212_DATA,
			PORT211_DATA, PORT210_DATA, PORT209_DATA, PORT208_DATA,
			PORT207_DATA, PORT206_DATA, PORT205_DATA, PORT204_DATA,
			PORT203_DATA, PORT202_DATA, PORT201_DATA, PORT200_DATA,
			PORT199_DATA, PORT198_DATA, PORT197_DATA, PORT196_DATA,
			PORT195_DATA, PORT194_DATA, PORT193_DATA, PORT192_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR255_224DR", 0xe6056008, 32) {
			0, 0, 0, 0,
			0, PORT250_DATA, PORT249_DATA, PORT248_DATA,
			PORT247_DATA, PORT246_DATA, PORT245_DATA, PORT244_DATA,
			PORT243_DATA, PORT242_DATA, PORT241_DATA, PORT240_DATA,
			PORT239_DATA, PORT238_DATA, PORT237_DATA, PORT236_DATA,
			PORT235_DATA, PORT234_DATA, PORT233_DATA, PORT232_DATA,
			PORT231_DATA, PORT230_DATA, PORT229_DATA, PORT228_DATA,
			PORT227_DATA, PORT226_DATA, PORT225_DATA, PORT224_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTR287_256DR", 0xe605600C, 32) {
			0, 0, 0, 0,
			PORT283_DATA, PORT282_DATA, PORT281_DATA, PORT280_DATA,
			PORT279_DATA, PORT278_DATA, PORT277_DATA, PORT276_DATA,
			PORT275_DATA, PORT274_DATA, PORT273_DATA, PORT272_DATA,
			PORT271_DATA, PORT270_DATA, PORT269_DATA, PORT268_DATA,
			PORT267_DATA, PORT266_DATA, PORT265_DATA, PORT264_DATA,
			PORT263_DATA, PORT262_DATA, PORT261_DATA, PORT260_DATA,
			PORT259_DATA, PORT258_DATA, PORT257_DATA, PORT256_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTU319_288DR", 0xe6057000, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, PORT308_DATA,
			PORT307_DATA, PORT306_DATA, PORT305_DATA, PORT304_DATA,
			PORT303_DATA, PORT302_DATA, PORT301_DATA, PORT300_DATA,
			PORT299_DATA, PORT298_DATA, PORT297_DATA, PORT296_DATA,
			PORT295_DATA, PORT294_DATA, PORT293_DATA, PORT292_DATA,
			PORT291_DATA, PORT290_DATA, PORT289_DATA, PORT288_DATA,
		}
	},
	{ PINMUX_DATA_REG("PORTU351_320DR", 0xe6057004, 32) {
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, PORT329_DATA, PORT328_DATA,
			PORT327_DATA, PORT326_DATA, PORT325_DATA, PORT324_DATA,
			PORT323_DATA, PORT322_DATA, PORT321_DATA, PORT320_DATA,
		}
	},
	{ },
};

static const struct pinmux_irq pinmux_irqs[] = {
	PINMUX_IRQ(irq_pin(0), 0),
	PINMUX_IRQ(irq_pin(1), 1),
	PINMUX_IRQ(irq_pin(2), 2),
	PINMUX_IRQ(irq_pin(3), 3),
	PINMUX_IRQ(irq_pin(4), 4),
	PINMUX_IRQ(irq_pin(5), 5),
	PINMUX_IRQ(irq_pin(6), 6),
	PINMUX_IRQ(irq_pin(7), 7),
	PINMUX_IRQ(irq_pin(8), 8),
	PINMUX_IRQ(irq_pin(9), 9),
	PINMUX_IRQ(irq_pin(10), 10),
	PINMUX_IRQ(irq_pin(11), 11),
	PINMUX_IRQ(irq_pin(12), 12),
	PINMUX_IRQ(irq_pin(13), 13),
	PINMUX_IRQ(irq_pin(14), 14),
	PINMUX_IRQ(irq_pin(15), 15),
	PINMUX_IRQ(irq_pin(16), 320),
	PINMUX_IRQ(irq_pin(17), 321),
	PINMUX_IRQ(irq_pin(18), 85),
	PINMUX_IRQ(irq_pin(19), 84),
	PINMUX_IRQ(irq_pin(20), 160),
	PINMUX_IRQ(irq_pin(21), 161),
	PINMUX_IRQ(irq_pin(22), 162),
	PINMUX_IRQ(irq_pin(23), 163),
	PINMUX_IRQ(irq_pin(24), 175),
	PINMUX_IRQ(irq_pin(25), 176),
	PINMUX_IRQ(irq_pin(26), 177),
	PINMUX_IRQ(irq_pin(27), 178),
	PINMUX_IRQ(irq_pin(28), 322),
	PINMUX_IRQ(irq_pin(29), 323),
	PINMUX_IRQ(irq_pin(30), 324),
	PINMUX_IRQ(irq_pin(31), 192),
	PINMUX_IRQ(irq_pin(32), 193),
	PINMUX_IRQ(irq_pin(33), 194),
	PINMUX_IRQ(irq_pin(34), 195),
	PINMUX_IRQ(irq_pin(35), 196),
	PINMUX_IRQ(irq_pin(36), 197),
	PINMUX_IRQ(irq_pin(37), 198),
	PINMUX_IRQ(irq_pin(38), 199),
	PINMUX_IRQ(irq_pin(39), 200),
	PINMUX_IRQ(irq_pin(40), 66),
	PINMUX_IRQ(irq_pin(41), 102),
	PINMUX_IRQ(irq_pin(42), 103),
	PINMUX_IRQ(irq_pin(43), 109),
	PINMUX_IRQ(irq_pin(44), 110),
	PINMUX_IRQ(irq_pin(45), 111),
	PINMUX_IRQ(irq_pin(46), 112),
	PINMUX_IRQ(irq_pin(47), 113),
	PINMUX_IRQ(irq_pin(48), 114),
	PINMUX_IRQ(irq_pin(49), 115),
	PINMUX_IRQ(irq_pin(50), 301),
	PINMUX_IRQ(irq_pin(51), 290),
	PINMUX_IRQ(irq_pin(52), 296),
	PINMUX_IRQ(irq_pin(53), 325),
	PINMUX_IRQ(irq_pin(54), 326),
	PINMUX_IRQ(irq_pin(55), 327),
	PINMUX_IRQ(irq_pin(56), 328),
	PINMUX_IRQ(irq_pin(57), 329),
};

#define PORTCR_PULMD_OFF (0 << 6)
#define PORTCR_PULMD_DOWN (2 << 6)
#define PORTCR_PULMD_UP (3 << 6)
#define PORTCR_PULMD_MASK (3 << 6)

static const unsigned int r8a73a4_portcr_offsets[] = {
	0x00000000, 0x00001000, 0x00000000, 0x00001000,
	0x00001000, 0x00002000, 0x00002000, 0x00002000,
	0x00002000, 0x00003000, 0x00003000,
};

static unsigned int r8a73a4_pinmux_get_bias(struct sh_pfc *pfc,
					    unsigned int pin)
{
	void __iomem *addr;

	addr = pfc->windows->virt + r8a73a4_portcr_offsets[pin >> 5] + pin;

	switch (ioread8(addr) & PORTCR_PULMD_MASK) {
	case PORTCR_PULMD_UP:
		return PIN_CONFIG_BIAS_PULL_UP;
	case PORTCR_PULMD_DOWN:
		return PIN_CONFIG_BIAS_PULL_DOWN;
	case PORTCR_PULMD_OFF:
	default:
		return PIN_CONFIG_BIAS_DISABLE;
	}
}

static void r8a73a4_pinmux_set_bias(struct sh_pfc *pfc, unsigned int pin,
				   unsigned int bias)
{
	void __iomem *addr;
	u32 value;

	addr = pfc->windows->virt + r8a73a4_portcr_offsets[pin >> 5] + pin;
	value = ioread8(addr) & ~PORTCR_PULMD_MASK;

	switch (bias) {
	case PIN_CONFIG_BIAS_PULL_UP:
		value |= PORTCR_PULMD_UP;
		break;
	case PIN_CONFIG_BIAS_PULL_DOWN:
		value |= PORTCR_PULMD_DOWN;
		break;
	}

	iowrite8(value, addr);
}

static const struct sh_pfc_soc_operations r8a73a4_pfc_ops = {
	.get_bias = r8a73a4_pinmux_get_bias,
	.set_bias = r8a73a4_pinmux_set_bias,
};

const struct sh_pfc_soc_info r8a73a4_pinmux_info = {
	.name		= "r8a73a4_pfc",
	.ops		= &r8a73a4_pfc_ops,

	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),

	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs	= pinmux_config_regs,
	.data_regs	= pinmux_data_regs,

	.gpio_data	= pinmux_data,
	.gpio_data_size	= ARRAY_SIZE(pinmux_data),

	.gpio_irq = pinmux_irqs,
	.gpio_irq_size = ARRAY_SIZE(pinmux_irqs),
};
