/*
 * oFono - Open Source Telephony
 * Copyright (C) 2011-2012  Intel Corporation
 *
 * SPDX-License-Identifier: GPL-2.0-only
 */

/* Start WDS network interface */
#define QMI_WDS_PARAM_PROFILE_TYPE		0x01
#define QMI_WDS_PARAM_APN			0x14	/* string */
#define QMI_WDS_PARAM_IP_FAMILY			0x19	/* uint8 */
#define QMI_WDS_PARAM_USERNAME			0x17	/* string */
#define QMI_WDS_PARAM_PASSWORD			0x18	/* string */
#define QMI_WDS_PARAM_AUTHENTICATION_PREFERENCE	0x16	/* uint8 */

enum qmi_wds_authentication {
	QMI_WDS_AUTHENTICATION_PAP	= 0x1,
	QMI_WDS_AUTHENTICATION_CHAP	= 0x2,
};

enum qmi_wds_connection_status {
	QMI_WDS_CONNECTION_STATUS_DISCONNECTED =	0x01,
	QMI_WDS_CONNECTION_STATUS_CONNECTED =		0x02,
	QMI_WDS_CONNECTION_STATUS_SUSPENDED =		0x03,
	QMI_WDS_CONNECTION_STATUS_AUTHENTICATING =	0x04,
};

enum qmi_wds_pdp_type {
	QMI_WDS_PDP_TYPE_IPV4		= 0x00,
	QMI_WDS_PDP_TYPE_PPP		= 0x01,
	QMI_WDS_PDP_TYPE_IPV6		= 0x02,
	QMI_WDS_PDP_TYPE_IPV4V6		= 0x03,
};

enum qmi_wds_ip_support {
	QMI_WDS_IP_SUPPORT_IPV4		= 0x00,
	QMI_WDS_IP_SUPPORT_IPV6		= 0x01,
	QMI_WDS_IP_SUPPORT_IPV4V6	= 0x02,
};

enum qmi_wds_ip_family {
	QMI_WDS_IP_FAMILY_UNKNOWN = 0,
	QMI_WDS_IP_FAMILY_IPV4 = 4,
	QMI_WDS_IP_FAMILY_IPV6 = 6,
	QMI_WDS_IP_FAMILY_UNSPECIFIED = 8,
};

enum qmi_wds_client_type {
	QMI_WDS_CLIENT_TYPE_TETHERED = 0x01,
};

enum qmi_wds_profile_type {
	QMI_WDS_PROFILE_TYPE_3GPP =	0x00,
	QMI_WDS_PROFILE_TYPE_3GPP2 =	0x01,
	QMI_WDS_PROFILE_TYPE_EPC =	0x02,
};

enum qmi_wds_profile_family {
	QMI_WDS_PROFILE_FAMILY_EMBEDDED =	0x00,
	QMI_WDS_PROFILE_FAMILY_TETHERED =	0x01,
};

enum qmi_wds_rat_3gpp {
	QMI_WDS_RAT_3GPP_WCDMA			= 0x01,
	QMI_WDS_RAT_3GPP_GPRS			= 0x02,
	QMI_WDS_RAT_3GPP_HSDPA			= 0x04,
	QMI_WDS_RAT_3GPP_HSUPA			= 0x08,
	QMI_WDS_RAT_3GPP_EDGE			= 0x10,
	QMI_WDS_RAT_3GPP_LTE			= 0x20,
	QMI_WDS_RAT_3GPP_HSDPAPLUS		= 0x40,
	QMI_WDS_RAT_3GPP_DCHSDPAPLUS		= 0x80,
	QMI_WDS_RAT_3GPP_64QAM			= 0x100,
	QMI_WDS_RAT_3GPP_TDSCDMA		= 0x200,
	QMI_WDS_RAT_3GPP_5GNR			= 0x400,
	QMI_WDS_RAT_3GPP_NULL_BEARER		= 0x8000,
};

enum qmi_wds_rat {
	QMI_WDS_RAT_WCDMA			= 0x01,
	QMI_WDS_RAT_GERAN			= 0x02,
	QMI_WDS_RAT_LTE				= 0x03,
	QMI_WDS_RAT_TDSCDMA			= 0x04,
	QMI_WDS_RAT_WLAN			= 0x05,
};

enum qmi_wds_service_option {
	QMI_WDS_SO_WCDMA			= 0x01ULL,
	QMI_WDS_SO_HSDPA			= 0x02ULL,
	QMI_WDS_SO_HSUPA			= 0x04ULL,
	QMI_WDS_SO_HSDPAPLUS			= 0x08ULL,
	QMI_WDS_SO_DC_HSDPAPLUS			= 0x10ULL,
	QMI_WDS_SO_64_QAM			= 0x20ULL,
	QMI_WDS_SO_HSPA				= 0x40ULL,
	QMI_WDS_SO_GPRS				= 0x80ULL,
	QMI_WDS_SO_EDGE				= 0x100ULL,
	QMI_WDS_SO_GSM				= 0x200ULL,
	QMI_WDS_SO_S2B				= 0x400ULL,
	QMI_WDS_SO_LTE_LIMITED			= 0x800ULL,
	QMI_WDS_SO_LTE_FDD			= 0x1000ULL,
	QMI_WDS_SO_LTE_TDD			= 0x2000ULL,
	QMI_WDS_SO_TDSCDMA			= 0x4000ULL,
	QMI_WDS_SO_DC_HSUPA			= 0x8000ULL,
	QMI_WDS_SO_LTE_CA_DL			= 0x10000ULL,
	QMI_WDS_SO_LTE_CA_UL			= 0x20000ULL,
	QMI_WDS_SO_S2B_LIMITED			= 0x40000ULL,
	QMI_WDS_SO_FOUR_POINT_FIVE_G		= 0x80000ULL,
	QMI_WDS_SO_FOUR_POINT_FIVE_G_PLUS	= 0x100000ULL,
	QMI_WDS_SO_5G_TDD			= 0x10000000000ULL,
	QMI_WDS_SO_5G_SUB6			= 0x20000000000ULL,
	QMI_WDS_SO_5G_MMWAVE			= 0x40000000000ULL,
	QMI_WDS_SO_5G_NSA			= 0x80000000000ULL,
	QMI_WDS_SO_5G_SA			= 0x100000000000ULL,
};

enum qmi_wds_command {
	QMI_WDS_RESET					= 0x00,
	QMI_WDS_EVENT_REPORT				= 0x01,
	QMI_WDS_ABORT					= 0x02,
	QMI_WDS_INDICATION_REGISTER			= 0x03,
	QMI_WDS_GET_SUPPORTED_MESSAGES			= 0x19,
	QMI_WDS_START_NETWORK				= 0x20,
	QMI_WDS_STOP_NETWORK				= 0x21,
	QMI_WDS_PACKET_SERVICE_STATUS			= 0x22,
	QMI_WDS_GET_CHANNEL_RATES			= 0x23,
	QMI_WDS_GET_PACKET_STATISTICS			= 0x24,
	QMI_WDS_GO_DORMANT				= 0x25,
	QMI_WDS_GO_ACTIVE				= 0x26,
	QMI_WDS_CREATE_PROFILE				= 0x27,
	QMI_WDS_MODIFY_PROFILE				= 0x28,
	QMI_WDS_DELETE_PROFILE				= 0x29,
	QMI_WDS_GET_PROFILE_LIST			= 0x2A,
	QMI_WDS_GET_PROFILE_SETTINGS			= 0x2B,
	QMI_WDS_GET_DEFAULT_SETTINGS			= 0x2C,
	QMI_WDS_GET_CURRENT_SETTINGS			= 0x2D,
	QMI_WDS_GET_DORMANCY_STATUS			= 0x30,
	QMI_WDS_GET_AUTOCONNECT_SETTINGS		= 0x34,
	QMI_WDS_GET_DATA_BEARER_TECHNOLOGY		= 0x37,
	QMI_WDS_GET_CURRENT_DATA_BEARER_TECHNOLOGY 	= 0x44,
	QMI_WDS_GET_DEFAULT_PROFILE_NUMBER		= 0x49,
	QMI_WDS_SET_DEFAULT_PROFILE_NUMBER		= 0x4A,
	QMI_WDS_RESET_PROFILE				= 0x4B,
	QMI_WDS_SET_IP_FAMILY				= 0x4D,
	QMI_WDS_SET_AUTOCONNECT_SETTINGS		= 0x51,
	QMI_WDS_GET_PDN_THROTTLE_INFO			= 0x6C,
	QMI_WDS_GET_LTE_ATTACH_PARAMETERS		= 0x85,
	QMI_WDS_BIND_DATA_PORT				= 0x89,
	QMI_WDS_EXTENDED_IP_CONFIG			= 0x8C,
	QMI_WDS_GET_MAX_LTE_ATTACH_PDN_NUMBER		= 0x92,
	QMI_WDS_SET_LTE_ATTACH_PDN_LIST			= 0x93,
	QMI_WDS_GET_LTE_ATTACH_PDN_LIST			= 0x94,
	QMI_WDS_BIND_MUX_DATA_PORT			= 0xA2,
	QMI_WDS_CONFIGURE_PROFILE_EVENT_LIST		= 0xA7,
	QMI_WDS_PROFILE_CHANGED				= 0xA8,
};

int qmi_wds_auth_from_ofono(enum ofono_gprs_auth_method method);
int qmi_wds_pdp_type_from_ofono(enum ofono_gprs_proto proto);

int qmi_wds_parse_data_system_status(const void *dss, uint16_t len);
int qmi_wds_parse_extended_data_bearer_technology(const void *edbt,
							uint16_t len);
