#
# Base functions for A3Com
#
# $Id: Base.pm,v 1.12 1999/06/02 15:18:08 trockij Exp $
#
# Copyright (C) 1998 Jim Trocki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

package A3Com::Base;
require 5.004;

use strict;
use vars qw($VERSION $DEFAULT_CACHETIME);

$VERSION = "0.02";

sub _mac_normalize;
sub _load;

if ($ENV{"A3COM_CACHE"}) {
    $DEFAULT_CACHETIME = $ENV{"A3COM_CACHE"} * 60;
} else {
    $DEFAULT_CACHETIME = 60 * 60 * 24;
}

sub _mac_normalize {
    my ($mac) = @_;
    my (@l, $a, $i);

    $mac = "\L$mac";
    foreach $a (split (/:/, $mac)) {
        $a =~ s/^(.)$/0\1/;
        push (@l, $a);
    }
    join (':', @l);
}


sub _load {
    my $self = shift;
    my $ext = shift;
    my ($t, $fdate, $file, $r);

    return if ($self->{_LOADED});

    $file = "$self->{CACHEDIR}/$self->{SWITCH}$ext";
    $fdate = (stat ($file))[9] if (-f $file);

    $t = time;

    if (!$self->{CACHE}) {
	$r = &{$self->{"READ_METHOD"}}($self);
	return undef if (!defined $r);

    } elsif (-f $file && $t - $fdate <= $self->{CACHETIME}) {
        return undef
	    if (!defined ($self->file_read ($file)));

    } else {
	$r = &{$self->{"READ_METHOD"}}($self);
	return undef if (!defined $r);

        if (! -d $self->{CACHEDIR} && ! mkdir ($self->{CACHEDIR}, 0775)) {
            $self->{ERROR} = "error making cachedir $self->{CACHEDIR}: $!";

            return undef;
        }

        return undef
	    if (!defined ($self->file_write ($file)));
    }
    $self->{_LOADED} = 1;
}


sub _load_global {
    my $self = shift;
    my $ext = shift;
    my ($r);

    return if ($self->{_LOADED});

    my $file = "$self->{GLOBALCACHEDIR}/$self->{SWITCH}$ext";
    my $fdate = (stat ($file))[9] if (-f $file);

    my $t = time;

    return undef if (!$self->{"GLOBALCACHE"});

    if (-f $file) {
        return undef if (!defined ($self->file_read ($file)));

    } else {
	$r = &{$self->{"READ_METHOD"}}($self);
	return undef if (!defined $r);
    }

    $self->{_LOADED} = 1;
}


sub _read_conf {
    my $self = shift;
    my $c = shift;

    $self->{"ERROR"} = "";

    my $CONF = $c || "/usr/local/etc/a3com.conf";

    if (!open (I, $CONF)) {
	# global conf is optional
	return ();
    }

    my %c = ();
    while (<I>) {
    	next if (/^\s*#/ || /^\s*$/);
	chomp;

	my ($var, $val) = split (/\s*=\s*/, $_, 2);
	$c{$var} = $val;
    }

    close (I);
    return %c;
}
